/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.util;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;

public abstract class UrlUtil {
    private UrlUtil() {
    }

    public static String addHttpPrefix(String address) {
        if (address == null) {
            return null;
        }
        if (address.trim().length() == 0) {
            return address;
        }
        if (!address.trim().startsWith("http://") && !address.trim().startsWith("https://")) {
            return "http://" + address.trim();
        }
        return address;
    }

    /*
     * Unable to fully structure code
     */
    public static String removeUrlTrailingSlashes(String address) {
        if (address == null) {
            return null;
        }
        try {
            url = new URL(address);
            if (url.getHost().length() == 0) {
                return address;
            }
            if (true) ** GOTO lbl12
        }
        catch (MalformedURLException v0) {
            return address;
        }
        do {
            address = address.substring(0, address.length() - 1);
lbl12:
            // 2 sources

        } while (address.endsWith("/"));
        return address;
    }

    public static void validateUrl(String urlString) throws MalformedURLException {
        if (urlString == null || urlString.length() == 0) {
            throw new MalformedURLException("Malformed URL: null or empty");
        }
        try {
            URL url = new URL(urlString);
            if (url.getHost().length() == 0) {
                throw new MalformedURLException("Url must contain valid host.");
            }
            if (url.getPort() >= 65534) {
                throw new MalformedURLException("Url port invalid");
            }
            url.toURI();
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException("Malformed URL: " + e.getMessage());
        }
        catch (MalformedURLException e) {
            throw new MalformedURLException("Malformed URL: " + e.getMessage());
        }
    }

    public static boolean isUrlValid(String urlString) {
        try {
            UrlUtil.validateUrl(urlString);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        return true;
    }

    public static String encodeUrl(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)"UTF-8 is not supported on this platform. In theory it should not happen, but ...");
        }
    }

    public static String adjustUrlPath(String urlPath, String serverUrl) {
        String[] serverTokens = serverUrl.split("/");
        String[] pathTokens = urlPath.split("/");
        if (serverTokens.length > 0 && pathTokens.length > 0 && serverTokens[serverTokens.length - 1].equals(pathTokens[0])) {
            urlPath = urlPath.substring(pathTokens[0].length(), urlPath.length());
        }
        return urlPath;
    }
}

