/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.fisheye;

import com.atlassian.connector.commons.api.ConnectionCfg;
import com.atlassian.connector.commons.fisheye.FishEyeServerFacade2;
import com.atlassian.theplugin.commons.ServerType;
import com.atlassian.theplugin.commons.fisheye.api.FishEyeSession;
import com.atlassian.theplugin.commons.fisheye.api.model.FisheyePathHistoryItem;
import com.atlassian.theplugin.commons.fisheye.api.rest.FishEyeRestSession;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiMalformedUrlException;
import com.atlassian.theplugin.commons.remoteapi.rest.HttpSessionCallback;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FishEyeServerFacadeImpl
implements FishEyeServerFacade2 {
    private static FishEyeServerFacadeImpl instance;
    private final HttpSessionCallback callback;

    public FishEyeServerFacadeImpl(HttpSessionCallback callback) {
        this.callback = callback;
    }

    @Override
    public void testServerConnection(ConnectionCfg serverCfg) throws RemoteApiException {
        FishEyeSession fishEyeSession = this.getSession(serverCfg);
        fishEyeSession.login(serverCfg.getUsername(), serverCfg.getPassword().toCharArray());
        fishEyeSession.getRepositories();
        fishEyeSession.logout();
    }

    @Override
    public ServerType getServerType() {
        return ServerType.FISHEYE_SERVER;
    }

    public static synchronized FishEyeServerFacadeImpl getInstance(HttpSessionCallback callback) {
        if (instance == null) {
            instance = new FishEyeServerFacadeImpl(callback);
        }
        return instance;
    }

    @Override
    public FishEyeSession getSession(ConnectionCfg server) throws RemoteApiMalformedUrlException {
        return new FishEyeRestSession(server, this.callback);
    }

    @Override
    public Collection<String> getRepositories(ConnectionCfg server) throws RemoteApiException {
        FishEyeSession fishEyeSession = this.getSession(server);
        fishEyeSession.login(server.getUsername(), server.getPassword().toCharArray());
        Collection<String> repositories = fishEyeSession.getRepositories();
        fishEyeSession.logout();
        return repositories;
    }

    @Override
    public Collection<FisheyePathHistoryItem> getPathHistory(ConnectionCfg server, String repo, String path) throws RemoteApiException {
        FishEyeSession fishEyeSession = this.getSession(server);
        fishEyeSession.login(server.getUsername(), server.getPassword().toCharArray());
        Collection<FisheyePathHistoryItem> items = fishEyeSession.getPathHistory(repo, path);
        fishEyeSession.logout();
        return items;
    }
}

