/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.cfg.xstream;

import com.atlassian.theplugin.commons.cfg.ServerCfgFactoryException;
import com.atlassian.theplugin.commons.cfg.xstream.JDomXStreamUtil;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.JDomReader;
import com.thoughtworks.xstream.io.xml.JDomWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasePrivateConfigurationDao<T> {
    private static final String ATLASSIAN_DIR_NAME = ".atlassian";
    private static final String ATLASSIAN_IDE_CONNECTOR_DIR_NAME = "ide-connector";

    void writeXmlFile(Element element, @NotNull File outputFile) throws IOException {
        StringWriter sw = new StringWriter();
        new XMLOutputter(Format.getPrettyFormat()).output(element, (Writer)sw);
        sw.flush();
        sw.close();
        String str = sw.toString();
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(outputFile.getAbsolutePath())));
        out.write(str);
        out.flush();
        out.close();
    }

    static void saveJDom(Object object, Element rootElement) {
        if (object == null) {
            throw new NullPointerException("Serialized object cannot be null");
        }
        JDomWriter writer = new JDomWriter(rootElement);
        XStream xStream = JDomXStreamUtil.getProjectJDomXStream(true);
        xStream.marshal(object, (HierarchicalStreamWriter)writer);
    }

    public static String getPrivateCfgDirectoryPath() {
        return String.valueOf(System.getProperty("user.home")) + File.separator + ATLASSIAN_DIR_NAME + File.separator + ATLASSIAN_IDE_CONNECTOR_DIR_NAME;
    }

    abstract String getRootElementName();

    public Document createJDom(T t) {
        Document document = new Document(new Element(this.getRootElementName()));
        BasePrivateConfigurationDao.saveJDom(t, document.getRootElement());
        return document;
    }

    protected static File getPrivateCfgDirectorySavePath() throws ServerCfgFactoryException {
        File ideConnectorHomeDir = new File(BasePrivateConfigurationDao.getPrivateCfgDirectoryPath());
        if (!ideConnectorHomeDir.exists() && !ideConnectorHomeDir.mkdirs()) {
            throw new ServerCfgFactoryException("Cannot create directory [" + ideConnectorHomeDir.getAbsolutePath() + "]");
        }
        if (ideConnectorHomeDir.isDirectory() && ideConnectorHomeDir.canWrite()) {
            return ideConnectorHomeDir;
        }
        throw new ServerCfgFactoryException("[" + ideConnectorHomeDir.getAbsolutePath() + "] is not writable" + " or is not a directory");
    }

    protected static <T1> T1 loadJDom(Element rootElement, Class<T1> clazz, Boolean saveAll) throws ServerCfgFactoryException {
        int childCount = rootElement.getChildren().size();
        if (childCount != 1) {
            throw new ServerCfgFactoryException("Cannot travers JDom tree. Exactly one child node expected, but found [" + childCount + "]");
        }
        JDomReader reader = new JDomReader((Element)rootElement.getChildren().get(0));
        XStream xStream = JDomXStreamUtil.getProjectJDomXStream(saveAll);
        try {
            return clazz.cast(xStream.unmarshal((HierarchicalStreamReader)reader));
        }
        catch (ClassCastException e) {
            throw new ServerCfgFactoryException("Cannot load " + clazz.getSimpleName() + " due to ClassCastException: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ServerCfgFactoryException("Cannot load " + clazz.getSimpleName() + ": " + e.getMessage(), e);
        }
    }

    public boolean isDirReady() throws ServerCfgFactoryException {
        File atlassianDir = BasePrivateConfigurationDao.getPrivateCfgDirectorySavePath();
        return atlassianDir.isDirectory() && atlassianDir.canRead();
    }
}

