/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.cfg;

import com.atlassian.theplugin.commons.ServerType;
import com.atlassian.theplugin.commons.cfg.PrivateServerCfgInfo;
import com.atlassian.theplugin.commons.cfg.ServerCfg;
import com.atlassian.theplugin.commons.cfg.ServerIdImpl;
import com.atlassian.theplugin.commons.cfg.UserCfg;

public class JiraServerCfg
extends ServerCfg {
    private static final int HASHCODE_MAGIC = 31;
    private boolean dontUseBasicAuth = true;
    private UserCfg basicHttpUser;

    public JiraServerCfg(String name, ServerIdImpl serverId, boolean dontUseBasicAuth) {
        super(true, name, serverId);
        this.dontUseBasicAuth = dontUseBasicAuth;
    }

    public JiraServerCfg(JiraServerCfg other) {
        super(other);
        this.dontUseBasicAuth = other.dontUseBasicAuth;
        this.basicHttpUser = other.basicHttpUser;
    }

    public JiraServerCfg(boolean enabled, String name, ServerIdImpl serverId, boolean dontUseBasicAuth) {
        super(enabled, name, serverId);
        this.dontUseBasicAuth = dontUseBasicAuth;
    }

    public JiraServerCfg(boolean enabled, String name, String url, ServerIdImpl serverId, boolean dontUseBasicAuth) {
        super(enabled, name, url, serverId);
        this.dontUseBasicAuth = dontUseBasicAuth;
    }

    public ServerType getServerType() {
        return ServerType.JIRA_SERVER;
    }

    public JiraServerCfg getClone() {
        return new JiraServerCfg(this);
    }

    public boolean isDontUseBasicAuth() {
        return this.dontUseBasicAuth;
    }

    public void setDontUseBasicAuth(boolean dontUseBasicAuth) {
        this.dontUseBasicAuth = dontUseBasicAuth;
    }

    public void setBasicHttpUser(UserCfg userCfg) {
        this.basicHttpUser = userCfg;
    }

    public UserCfg getBasicHttpUser() {
        return this.basicHttpUser;
    }

    public PrivateServerCfgInfo createPrivateProjectConfiguration() {
        return new PrivateServerCfgInfo(this.getServerId(), this.isEnabled(), this.isUseDefaultCredentials(), this.getUsername(), this.isPasswordStored() ? this.getPassword() : null, !this.dontUseBasicAuth, this.basicHttpUser != null ? this.basicHttpUser.getUsername() : "", this.basicHttpUser != null ? this.basicHttpUser.getPassword() : "", this.isShared());
    }

    public void mergePrivateConfiguration(PrivateServerCfgInfo psci) {
        super.mergePrivateConfiguration(psci);
        if (psci != null) {
            this.setDontUseBasicAuth(!psci.isUseHttpBasic());
            this.setBasicHttpUser(new UserCfg(psci.getBasicUsername(), psci.getBasicPassword()));
        } else {
            this.setDontUseBasicAuth(true);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JiraServerCfg that = (JiraServerCfg)o;
        if (this.dontUseBasicAuth != that.dontUseBasicAuth) {
            return false;
        }
        return !(this.basicHttpUser != null ? !this.basicHttpUser.equals(that.basicHttpUser) : that.basicHttpUser != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.dontUseBasicAuth ? 1 : 0);
        result = 31 * result + (this.basicHttpUser != null ? this.basicHttpUser.hashCode() : 0);
        return result;
    }
}

