/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.cfg;

import com.atlassian.theplugin.commons.ServerType;
import com.atlassian.theplugin.commons.cfg.PrivateBambooServerCfgInfo;
import com.atlassian.theplugin.commons.cfg.PrivateServerCfgInfo;
import com.atlassian.theplugin.commons.cfg.ServerCfg;
import com.atlassian.theplugin.commons.cfg.ServerIdImpl;
import com.atlassian.theplugin.commons.cfg.SubscribedPlan;
import com.atlassian.theplugin.commons.cfg.UserCfg;
import com.atlassian.theplugin.commons.util.MiscUtil;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BambooServerCfg
extends ServerCfg {
    private boolean isUseFavourites;
    private boolean showBranches;
    private boolean myBranchesOnly;
    private boolean isBamboo2;
    private Collection<SubscribedPlan> plans = MiscUtil.buildArrayList();
    private int timezoneOffset;

    public BambooServerCfg(String name, ServerIdImpl serverId) {
        super(true, name, serverId);
    }

    public BambooServerCfg(String name, String url, ServerIdImpl serverId) {
        super(true, name, url, serverId);
    }

    public BambooServerCfg(boolean enabled, String name, ServerIdImpl serverId) {
        super(enabled, name, serverId);
        this.showBranches = true;
    }

    public BambooServerCfg(BambooServerCfg other) {
        super(other);
        this.isUseFavourites = other.isUseFavourites();
        this.showBranches = other.isShowBranches();
        this.myBranchesOnly = other.isMyBranchesOnly();
        this.isBamboo2 = other.isBamboo2();
        this.plans = MiscUtil.buildArrayList(other.getPlans());
        this.timezoneOffset = other.timezoneOffset;
    }

    @Override
    public ServerType getServerType() {
        return ServerType.BAMBOO_SERVER;
    }

    @Override
    public boolean isDontUseBasicAuth() {
        return true;
    }

    @Override
    public UserCfg getBasicHttpUser() {
        return null;
    }

    public boolean isUseFavourites() {
        return this.isUseFavourites;
    }

    public Collection<SubscribedPlan> getSubscribedPlans() {
        return this.plans;
    }

    public void clearSubscribedPlans() {
        this.plans.clear();
    }

    public void setUseFavourites(boolean useFavourites) {
        this.isUseFavourites = useFavourites;
    }

    public void setShowBranches(boolean showBranches) {
        this.showBranches = showBranches;
    }

    public void setMyBranchesOnly(boolean myBranchesOnly) {
        this.myBranchesOnly = myBranchesOnly;
    }

    public int getTimezoneOffset() {
        return this.timezoneOffset;
    }

    public void setTimezoneOffset(int timezoneOffset) {
        this.timezoneOffset = timezoneOffset;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof BambooServerCfg)) {
            return false;
        }
        BambooServerCfg that = (BambooServerCfg)o;
        if (this.isUseFavourites != that.isUseFavourites) {
            return false;
        }
        if (this.showBranches != that.showBranches) {
            return false;
        }
        if (this.myBranchesOnly != that.myBranchesOnly) {
            return false;
        }
        if (!this.plans.equals(that.plans)) {
            return false;
        }
        return this.timezoneOffset == that.timezoneOffset;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.isUseFavourites ? 1 : 0);
        result = 31 * result + (this.showBranches ? 1 : 0);
        result = 31 * result + (this.myBranchesOnly ? 1 : 0);
        return result;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("Bamboo Server [");
        builder.append(super.toString());
        builder.append("]");
        return builder.toString();
    }

    public void setIsBamboo2(boolean b) {
        this.isBamboo2 = b;
    }

    public boolean isBamboo2() {
        return this.isBamboo2;
    }

    public boolean isShowBranches() {
        return this.showBranches;
    }

    public boolean isMyBranchesOnly() {
        return this.myBranchesOnly;
    }

    public Collection<SubscribedPlan> getPlans() {
        return this.plans;
    }

    public void setPlans(Collection<SubscribedPlan> plans) {
        this.plans = plans;
    }

    @Override
    public BambooServerCfg getClone() {
        return new BambooServerCfg(this);
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        if (this.plans == null) {
            this.plans = MiscUtil.buildArrayList();
        }
        return this;
    }

    @Override
    public PrivateServerCfgInfo createPrivateProjectConfiguration() {
        return new PrivateBambooServerCfgInfo(this.getServerId(), this.isEnabled(), this.isUseDefaultCredentials(), this.getUsername(), this.isPasswordStored() ? this.getPassword() : null, this.getTimezoneOffset(), false, "", "", this.isShared(), this.getPlans(), this.isUseFavourites);
    }

    @Override
    public void mergePrivateConfiguration(PrivateServerCfgInfo psci) {
        super.mergePrivateConfiguration(psci);
        if (psci != null) {
            try {
                this.setTimezoneOffset(((PrivateBambooServerCfgInfo)psci).getTimezoneOffset());
                this.setPlans(((PrivateBambooServerCfgInfo)psci).getPlans());
                this.isUseFavourites = ((PrivateBambooServerCfgInfo)psci).isUseFavourites();
            }
            catch (ClassCastException classCastException) {}
        }
    }
}

