/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.commons.jira.soap;

import com.atlassian.connector.commons.api.ConnectionCfg;
import com.atlassian.connector.commons.jira.JIRAAction;
import com.atlassian.connector.commons.jira.JIRAActionBean;
import com.atlassian.connector.commons.jira.JIRAActionField;
import com.atlassian.connector.commons.jira.JIRAActionFieldBean;
import com.atlassian.connector.commons.jira.JIRAIssue;
import com.atlassian.connector.commons.jira.JIRAIssueBean;
import com.atlassian.connector.commons.jira.JIRASessionPartOne;
import com.atlassian.connector.commons.jira.JiraUserNotFoundException;
import com.atlassian.connector.commons.jira.beans.JIRAAttachment;
import com.atlassian.connector.commons.jira.beans.JIRAComment;
import com.atlassian.connector.commons.jira.beans.JIRACommentBean;
import com.atlassian.connector.commons.jira.beans.JIRAComponentBean;
import com.atlassian.connector.commons.jira.beans.JIRAConstant;
import com.atlassian.connector.commons.jira.beans.JIRAIssueTypeBean;
import com.atlassian.connector.commons.jira.beans.JIRAPriorityBean;
import com.atlassian.connector.commons.jira.beans.JIRAProject;
import com.atlassian.connector.commons.jira.beans.JIRAProjectBean;
import com.atlassian.connector.commons.jira.beans.JIRAQueryFragment;
import com.atlassian.connector.commons.jira.beans.JIRAResolutionBean;
import com.atlassian.connector.commons.jira.beans.JIRASavedFilterBean;
import com.atlassian.connector.commons.jira.beans.JIRASecurityLevelBean;
import com.atlassian.connector.commons.jira.beans.JIRAStatusBean;
import com.atlassian.connector.commons.jira.beans.JIRAUserBean;
import com.atlassian.connector.commons.jira.beans.JIRAVersionBean;
import com.atlassian.connector.commons.jira.soap.AxisSessionCallback;
import com.atlassian.connector.commons.jira.soap.axis.JiraSoapService;
import com.atlassian.connector.commons.jira.soap.axis.JiraSoapServiceServiceLocator;
import com.atlassian.connector.commons.jira.soap.axis.RemoteAttachment;
import com.atlassian.connector.commons.jira.soap.axis.RemoteAuthenticationException;
import com.atlassian.connector.commons.jira.soap.axis.RemoteComment;
import com.atlassian.connector.commons.jira.soap.axis.RemoteComponent;
import com.atlassian.connector.commons.jira.soap.axis.RemoteField;
import com.atlassian.connector.commons.jira.soap.axis.RemoteFieldValue;
import com.atlassian.connector.commons.jira.soap.axis.RemoteFilter;
import com.atlassian.connector.commons.jira.soap.axis.RemoteIssue;
import com.atlassian.connector.commons.jira.soap.axis.RemoteIssueType;
import com.atlassian.connector.commons.jira.soap.axis.RemoteNamedObject;
import com.atlassian.connector.commons.jira.soap.axis.RemotePriority;
import com.atlassian.connector.commons.jira.soap.axis.RemoteProject;
import com.atlassian.connector.commons.jira.soap.axis.RemoteResolution;
import com.atlassian.connector.commons.jira.soap.axis.RemoteSecurityLevel;
import com.atlassian.connector.commons.jira.soap.axis.RemoteStatus;
import com.atlassian.connector.commons.jira.soap.axis.RemoteUser;
import com.atlassian.connector.commons.jira.soap.axis.RemoteVersion;
import com.atlassian.connector.commons.jira.soap.axis.RemoteWorklog;
import com.atlassian.theplugin.commons.configuration.ConfigurationFactory;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiLoginException;
import com.atlassian.theplugin.commons.remoteapi.rest.AbstractHttpSession;
import com.atlassian.theplugin.commons.util.HttpConfigurableAdapter;
import com.atlassian.theplugin.commons.util.Logger;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisProperties;
import org.apache.commons.codec.binary.Base64;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JIRASoapSessionImpl
implements JIRASessionPartOne {
    private String token;
    private final JiraSoapService service;
    private final ConnectionCfg httpConnectionCfg;
    private boolean loggedIn;
    private final Logger logger;
    private Date lastUsed = new Date();

    public Date getLastUsed() {
        return this.lastUsed;
    }

    public void setLastUsed(Date lastUsed) {
        this.lastUsed = lastUsed;
    }

    private void setAxisProperty(String name, String value) {
        if (value == null) {
            if (AxisProperties.getProperty((String)name) != null) {
                try {
                    AxisProperties.setProperty((String)name, (String)"");
                }
                catch (NullPointerException e) {
                    this.logger.info("Setting AXIS property " + name + " to empty", e);
                }
            }
        } else {
            AxisProperties.setProperty((String)name, (String)value);
        }
    }

    private void setSystemProperty(String name, String value) {
        if (value == null) {
            try {
                System.setProperty(name, "");
            }
            catch (NullPointerException e) {
                this.logger.info("Setting system property " + name + " to empty", e);
            }
        } else {
            System.setProperty(name, value);
        }
    }

    private void setProxy() {
        boolean useIdeaProxySettings = ConfigurationFactory.getConfiguration().getGeneralConfigurationData().getUseIdeaProxySettings();
        HttpConfigurableAdapter proxyInfo = ConfigurationFactory.getConfiguration().transientGetHttpConfigurable();
        String host = null;
        String port = null;
        String user = null;
        String password = null;
        if (useIdeaProxySettings && proxyInfo.isUseHttpProxy()) {
            host = proxyInfo.getProxyHost();
            port = String.valueOf(proxyInfo.getProxyPort());
            if (proxyInfo.isProxyAuthentication()) {
                user = proxyInfo.getProxyLogin();
                password = proxyInfo.getPlainProxyPassword();
            }
        }
        this.setAxisProperty("http.proxyHost", host);
        this.setAxisProperty("http.proxyPort", port);
        this.setSystemProperty("http.proxyHost", host);
        this.setSystemProperty("http.proxyPort", port);
        this.setAxisProperty("http.proxyUser", user);
        this.setSystemProperty("http.proxyUser", user);
        this.setAxisProperty("http.proxyPassword", password);
        this.setSystemProperty("http.proxyPassword", password);
    }

    public JIRASoapSessionImpl(Logger logger, ConnectionCfg connectionCfg, AxisSessionCallback callback) throws ServiceException, MalformedURLException {
        this.logger = logger;
        URL portAddress = new URL(String.valueOf(connectionCfg.getUrl()) + "/rpc/soap/jirasoapservice-v2");
        JiraSoapServiceServiceLocator loc = new JiraSoapServiceServiceLocator();
        AbstractHttpSession.setUrl(portAddress);
        this.service = loc.getJirasoapserviceV2(portAddress);
        if (callback != null) {
            callback.configureRemoteService(this.service, connectionCfg);
        }
        this.setProxy();
        this.httpConnectionCfg = connectionCfg;
    }

    @Override
    public void login(String userName, String password) throws RemoteApiException {
        try {
            this.token = this.service.login(userName, password);
        }
        catch (RemoteAuthenticationException e) {
            if (e != null && e.getFaultString() != null && e.getFaultString().contains("The maximum number of failed login attempts")) {
                throw new RemoteApiLoginException("Due to multiple failed login attempts, you have been temporarily banned from using the remote API.\nTo re-enable the remote API please log into your server via the web interface", (Throwable)((Object)e));
            }
            throw new RemoteApiLoginException("Authentication failed", (Throwable)((Object)e));
        }
        catch (RemoteException e) {
            throw new RemoteApiException(e.toString());
        }
        this.loggedIn = true;
    }

    @Override
    public void logout() {
        try {
            if (this.service.logout(this.token)) {
                this.token = null;
                this.loggedIn = false;
            }
        }
        catch (RemoteException remoteException) {}
    }

    @Override
    public void logWork(JIRAIssue issue, String timeSpent, Calendar startDate, String comment, boolean updateEstimate, String newEstimate) throws RemoteApiException {
        RemoteWorklog workLog = new RemoteWorklog();
        workLog.setStartDate(startDate);
        workLog.setTimeSpent(timeSpent);
        if (comment != null) {
            workLog.setComment(comment);
        }
        try {
            if (updateEstimate) {
                if (newEstimate != null) {
                    this.service.addWorklogWithNewRemainingEstimate(this.token, issue.getKey(), workLog, newEstimate);
                } else {
                    this.service.addWorklogAndAutoAdjustRemainingEstimate(this.token, issue.getKey(), workLog);
                }
            } else {
                this.service.addWorklogAndRetainRemainingEstimate(this.token, issue.getKey(), workLog);
            }
        }
        catch (RemoteException e) {
            throw new RemoteApiException(e.toString(), e);
        }
    }

    @Override
    public JIRAIssue createIssue(JIRAIssue issue) throws RemoteApiException {
        List<JIRAConstant> fixVersions;
        List<JIRAConstant> versions;
        List<JIRAConstant> components;
        RemoteIssue remoteIssue = new RemoteIssue();
        remoteIssue.setProject(issue.getProjectKey());
        remoteIssue.setType(String.valueOf(issue.getTypeConstant().getId()));
        remoteIssue.setSummary(issue.getSummary());
        if (issue.getPriorityConstant().getId() != -1000L) {
            remoteIssue.setPriority(String.valueOf(issue.getPriorityConstant().getId()));
        }
        if (issue.getDescription() != null) {
            remoteIssue.setDescription(issue.getDescription());
        }
        if (issue.getAssignee() != null) {
            remoteIssue.setAssignee(issue.getAssignee());
        }
        if ((components = issue.getComponents()) != null && components.size() > 0) {
            RemoteComponent[] remoteComponents = new RemoteComponent[components.size()];
            int i = 0;
            for (JIRAConstant component : components) {
                remoteComponents[i] = new RemoteComponent(String.valueOf(component.getId()), component.getName());
                ++i;
            }
            remoteIssue.setComponents(remoteComponents);
        }
        if ((versions = issue.getAffectsVersions()) != null && versions.size() > 0) {
            RemoteVersion[] remoteVersions = new RemoteVersion[versions.size()];
            int i = 0;
            for (JIRAConstant version : versions) {
                remoteVersions[i] = new RemoteVersion();
                remoteVersions[i].setId(String.valueOf(version.getId()));
                ++i;
            }
            remoteIssue.setAffectsVersions(remoteVersions);
        }
        if ((fixVersions = issue.getFixVersions()) != null && fixVersions.size() > 0) {
            RemoteVersion[] remoteFixVersions = new RemoteVersion[fixVersions.size()];
            int i = 0;
            for (JIRAConstant version : fixVersions) {
                remoteFixVersions[i] = new RemoteVersion();
                remoteFixVersions[i].setId(String.valueOf(version.getId()));
                ++i;
            }
            remoteIssue.setFixVersions(remoteFixVersions);
        }
        try {
            remoteIssue = this.service.createIssue(this.token, remoteIssue);
        }
        catch (RemoteException e) {
            throw new RemoteApiException(e.toString(), e);
        }
        JIRAIssueBean retVal = new JIRAIssueBean(this.httpConnectionCfg.getUrl(), remoteIssue);
        retVal.setKey(remoteIssue.getKey());
        return retVal;
    }

    @Override
    public JIRAIssue getIssueDetails(JIRAIssue issue) throws RemoteApiException {
        RemoteSecurityLevel securityLevel = null;
        try {
            securityLevel = this.service.getSecurityLevel(this.token, issue.getKey());
        }
        catch (RemoteException e) {
            if (this.logger != null) {
                this.logger.warn("Soap method 'getSecurityLevel' thrown exception. Probably there is no 'SecurityLevel' on JIRA (non enterprise version of JIRA).", e);
            }
        }
        catch (ClassCastException e) {
            if (this.logger != null) {
                this.logger.warn("Soap method 'getSecurityLevel' thrown ClassCastException. Probably some JIRA error.", e);
            }
        }
        catch (Exception e) {
            if (e instanceof SAXException && this.logger != null) {
                this.logger.warn("Soap method 'getSecurityLevel' thrown SAXException. Probably some JIRA error.", e);
            }
            throw new RemoteApiException(e);
        }
        try {
            RemoteIssue rIssue = this.service.getIssue(this.token, issue.getKey());
            if (rIssue == null) {
                throw new RemoteApiException("Unable to retrieve issue details");
            }
            JIRAIssueBean issueBean = new JIRAIssueBean(issue);
            if (securityLevel != null) {
                issueBean.setSecurityLevel(new JIRASecurityLevelBean(Long.valueOf(securityLevel.getId()), securityLevel.getName()));
            }
            issueBean.setWikiDescription(rIssue.getDescription());
            RemoteVersion[] aVers = rIssue.getAffectsVersions();
            ArrayList<JIRAConstant> av = new ArrayList<JIRAConstant>();
            RemoteVersion[] remoteVersionArray = aVers;
            int n = aVers.length;
            int n2 = 0;
            while (n2 < n) {
                RemoteVersion v = remoteVersionArray[n2];
                av.add(new JIRAVersionBean((long)Long.valueOf(v.getId()), v.getName(), v.isReleased()));
                ++n2;
            }
            issueBean.setAffectsVersions(av);
            RemoteVersion[] fVers = rIssue.getFixVersions();
            ArrayList<JIRAConstant> fv = new ArrayList<JIRAConstant>();
            RemoteVersion[] remoteVersionArray2 = fVers;
            int n3 = fVers.length;
            int n4 = 0;
            while (n4 < n3) {
                RemoteVersion v = remoteVersionArray2[n4];
                fv.add(new JIRAVersionBean((long)Long.valueOf(v.getId()), v.getName(), v.isReleased()));
                ++n4;
            }
            issueBean.setFixVersions(fv);
            RemoteComponent[] comps = rIssue.getComponents();
            ArrayList<JIRAConstant> c = new ArrayList<JIRAConstant>();
            RemoteComponent[] remoteComponentArray = comps;
            int n5 = comps.length;
            int n6 = 0;
            while (n6 < n5) {
                RemoteComponent rc = remoteComponentArray[n6];
                c.add(new JIRAComponentBean(Long.valueOf(rc.getId()), rc.getName()));
                ++n6;
            }
            issueBean.setComponents(c);
            issueBean.setProjectKey(rIssue.getProject());
            issueBean.setSummary(rIssue.getSummary());
            issueBean.setApiIssueObject(rIssue);
            return issueBean;
        }
        catch (RemoteException e) {
            throw new RemoteApiException(e.toString(), e);
        }
        catch (ClassCastException e) {
            throw new RemoteApiException(e.toString(), e);
        }
        catch (Exception e) {
            if (e instanceof SAXException && this.logger != null) {
                this.logger.warn("Soap method 'getIssue' thrown SAXException. Probably some JIRA error or weird JIRA SOAP plugin.", e);
            }
            throw new RemoteApiException(e);
        }
    }

    @Override
    public void addComment(String issueKey, String comment) throws RemoteApiException {
        try {
            RemoteComment rComment = new RemoteComment();
            rComment.setBody(comment);
            this.service.addComment(this.token, issueKey, rComment);
        }
        catch (RemoteException e) {
            throw new RemoteApiException(e.toString(), e);
        }
    }

    @Override
    public void addAttachment(String issueKey, String name, byte[] content) throws RemoteApiException {
        String[] encodedContents = new String[]{new String(new Base64().encode(content))};
        String[] names = new String[]{name};
        try {
            this.service.addBase64EncodedAttachmentsToIssue(this.token, issueKey, names, encodedContents);
        }
        catch (RemoteException e) {
            if (e.toString().startsWith("java.lang.OutOfMemoryError")) {
                throw new RemoteApiException("Attachment size is too large, try uploading directly from web browser", e);
            }
            throw new RemoteApiException(e.toString(), e);
        }
    }

    @Override
    public List<JIRAProject> getProjects() throws RemoteApiException {
        try {
            RemoteProject[] projects = this.service.getProjectsNoSchemes(this.token);
            ArrayList<JIRAProject> projectList = new ArrayList<JIRAProject>(projects.length);
            if (projects != null) {
                RemoteProject[] remoteProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    RemoteProject p = remoteProjectArray[n2];
                    JIRAProjectBean project = new JIRAProjectBean();
                    project.setName(p.getName());
                    project.setKey(p.getKey());
                    project.setDescription(p.getDescription());
                    project.setUrl(p.getUrl());
                    project.setLead(p.getLead());
                    project.setId(Long.valueOf(p.getId()));
                    projectList.add(project);
                    ++n2;
                }
            }
            return projectList;
        }
        catch (RemoteException e) {
            throw new RemoteApiException(e.toString(), e);
        }
    }

    private List<JIRAConstant> issueTableToList(RemoteIssueType[] types) throws MalformedURLException {
        ArrayList<JIRAConstant> typesList = new ArrayList<JIRAConstant>();
        if (types != null) {
            RemoteIssueType[] remoteIssueTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                RemoteIssueType type = remoteIssueTypeArray[n2];
                typesList.add(new JIRAIssueTypeBean(Long.valueOf(type.getId()), type.getName(), new URL(type.getIcon())));
                ++n2;
            }
        }
        return typesList;
    }

    @Override
    public List<JIRAConstant> getIssueTypes() throws RemoteApiException {
        try {
            return this.issueTableToList(this.service.getIssueTypes(this.token));
        }
        catch (RemoteException e) {
            throw new RemoteApiException(e.toString(), e);
        }
        catch (MalformedURLException e) {
            throw new RemoteApiException(e.toString(), e);
        }
    }

    @Override
    public List<JIRAConstant> getIssueTypesForProject(long projectId, String projectKey) throws RemoteApiException {
        try {
            return this.issueTableToList(this.service.getIssueTypesForProject(this.token, Long.valueOf(projectId).toString()));
        }
        catch (RemoteException e) {
            throw new RemoteApiException(e.toString(), e);
        }
        catch (MalformedURLException e) {
            throw new RemoteApiException(e.toString(), e);
        }
    }

    @Override
    public List<JIRAConstant> getSubtaskIssueTypes() throws RemoteApiException {
        try {
            return this.issueTableToList(this.service.getSubTaskIssueTypes(this.token));
        }
        catch (RemoteException e) {
            throw new RemoteApiException(e.toString(), e);
        }
        catch (MalformedURLException e) {
            throw new RemoteApiException(e.toString(), e);
        }
    }

    @Override
    public List<JIRAConstant> getSubtaskIssueTypesForProject(long projectId, String projectKey) throws RemoteApiException {
        try {
            return this.issueTableToList(this.service.getSubTaskIssueTypesForProject(this.token, Long.valueOf(projectId).toString()));
        }
        catch (RemoteException e) {
            throw new RemoteApiException(e.toString(), e);
        }
        catch (MalformedURLException e) {
            throw new RemoteApiException(e.toString(), e);
        }
    }

    @Override
    public List<JIRAConstant> getStatuses() throws RemoteApiException {
        try {
            RemoteStatus[] statuses = this.service.getStatuses(this.token);
            ArrayList<JIRAConstant> statusesList = new ArrayList<JIRAConstant>();
            if (statuses != null) {
                RemoteStatus[] remoteStatusArray = statuses;
                int n = statuses.length;
                int n2 = 0;
                while (n2 < n) {
                    RemoteStatus status = remoteStatusArray[n2];
                    statusesList.add(new JIRAStatusBean(Long.valueOf(status.getId()), status.getName(), new URL(status.getIcon())));
                    ++n2;
                }
            }
            return statusesList;
        }
        catch (RemoteException e) {
            throw new RemoteApiException(e.toString(), e);
        }
        catch (MalformedURLException e) {
            throw new RemoteApiException(e.toString(), e);
        }
    }

    @Override
    public List<JIRAComponentBean> getComponents(String projectKey) throws RemoteApiException {
        try {
            RemoteComponent[] components = this.service.getComponents(this.token, projectKey);
            ArrayList<JIRAComponentBean> componentsList = new ArrayList<JIRAComponentBean>();
            if (components != null) {
                RemoteComponent[] remoteComponentArray = components;
                int n = components.length;
                int n2 = 0;
                while (n2 < n) {
                    RemoteComponent c = remoteComponentArray[n2];
                    componentsList.add(new JIRAComponentBean(Long.valueOf(c.getId()), c.getName()));
                    ++n2;
                }
            }
            return componentsList;
        }
        catch (RemoteException e) {
            throw new RemoteApiException(e.toString(), e);
        }
    }

    @Override
    public List<JIRAVersionBean> getVersions(String projectKey) throws RemoteApiException {
        try {
            RemoteVersion[] versions = this.service.getVersions(this.token, projectKey);
            ArrayList<JIRAVersionBean> versionsList = new ArrayList<JIRAVersionBean>();
            if (versions != null) {
                RemoteVersion[] remoteVersionArray = versions;
                int n = versions.length;
                int n2 = 0;
                while (n2 < n) {
                    RemoteVersion v = remoteVersionArray[n2];
                    versionsList.add(new JIRAVersionBean((long)Long.valueOf(v.getId()), v.getName(), v.isReleased()));
                    ++n2;
                }
            }
            return versionsList;
        }
        catch (RemoteException e) {
            throw new RemoteApiException(e.toString() != null ? e.toString() : "Cannot fetch project '" + projectKey + "' versions", e);
        }
    }

    @Override
    public List<JIRAPriorityBean> getPriorities() throws RemoteApiException {
        try {
            RemotePriority[] priorities = this.service.getPriorities(this.token);
            ArrayList<JIRAPriorityBean> prioritiesList = new ArrayList<JIRAPriorityBean>();
            int i = 0;
            if (priorities != null) {
                RemotePriority[] remotePriorityArray = priorities;
                int n = priorities.length;
                int n2 = 0;
                while (n2 < n) {
                    RemotePriority p = remotePriorityArray[n2];
                    prioritiesList.add(new JIRAPriorityBean(Long.valueOf(p.getId()), i, p.getName(), new URL(p.getIcon())));
                    ++i;
                    ++n2;
                }
            }
            return prioritiesList;
        }
        catch (RemoteException e) {
            throw new RemoteApiException(e.toString(), e);
        }
        catch (MalformedURLException e) {
            throw new RemoteApiException(e.toString(), e);
        }
    }

    @Override
    public List<JIRAResolutionBean> getResolutions() throws RemoteApiException {
        try {
            RemoteResolution[] resolutions = this.service.getResolutions(this.token);
            ArrayList<JIRAResolutionBean> resolutionsList = new ArrayList<JIRAResolutionBean>();
            if (resolutions != null) {
                RemoteResolution[] remoteResolutionArray = resolutions;
                int n = resolutions.length;
                int n2 = 0;
                while (n2 < n) {
                    RemoteResolution p = remoteResolutionArray[n2];
                    resolutionsList.add(new JIRAResolutionBean(Long.valueOf(p.getId()), p.getName()));
                    ++n2;
                }
            }
            return resolutionsList;
        }
        catch (RemoteException e) {
            throw new RemoteApiException(e.toString(), e);
        }
    }

    @Override
    public List<JIRAQueryFragment> getSavedFilters() throws RemoteApiException {
        try {
            RemoteFilter[] filters = this.service.getSavedFilters(this.token);
            ArrayList<JIRAQueryFragment> filtersList = new ArrayList<JIRAQueryFragment>(filters != null ? filters.length : 0);
            if (filters != null) {
                RemoteFilter[] remoteFilterArray = filters;
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    RemoteFilter f = remoteFilterArray[n2];
                    if (f != null) {
                        filtersList.add(new JIRASavedFilterBean(f.getName(), Long.valueOf(f.getId())));
                    }
                    ++n2;
                }
            }
            return filtersList;
        }
        catch (RemoteException e) {
            throw new RemoteApiException(e.toString(), e);
        }
    }

    @Override
    public void setField(JIRAIssue issue, String fieldId, String value) throws RemoteApiException {
        this.setField(issue, fieldId, new String[]{value});
    }

    @Override
    public void setField(JIRAIssue issue, String fieldId, String[] values) throws RemoteApiException {
        RemoteFieldValue v = new RemoteFieldValue();
        RemoteFieldValue[] vTable = new RemoteFieldValue[]{v};
        v.setId(fieldId);
        v.setValues(values);
        try {
            this.service.updateIssue(this.token, issue.getKey(), vTable);
        }
        catch (RemoteException e) {
            throw new RemoteApiException(e.toString(), e);
        }
    }

    @Override
    public void setFields(JIRAIssue issue, List<JIRAActionField> fields) throws RemoteApiException {
        RemoteFieldValue[] vTable = new RemoteFieldValue[fields.size()];
        int i = 0;
        for (JIRAActionField field : fields) {
            vTable[i] = new RemoteFieldValue();
            vTable[i].setId(field.getFieldId());
            vTable[i].setValues(field.getValues().toArray(new String[field.getValues().size()]));
            ++i;
        }
        try {
            this.service.updateIssue(this.token, issue.getKey(), vTable);
        }
        catch (RemoteException e) {
            throw new RemoteApiException(e.toString(), e);
        }
    }

    @Override
    public List<JIRAAction> getAvailableActions(JIRAIssue issue) throws RemoteApiException {
        try {
            RemoteNamedObject[] actions = this.service.getAvailableActions(this.token, issue.getKey());
            ArrayList<JIRAAction> actionList = new ArrayList<JIRAAction>(actions != null ? actions.length : 0);
            if (actions != null) {
                RemoteNamedObject[] remoteNamedObjectArray = actions;
                int n = actions.length;
                int n2 = 0;
                while (n2 < n) {
                    RemoteNamedObject action = remoteNamedObjectArray[n2];
                    actionList.add(new JIRAActionBean(Long.valueOf(action.getId()), action.getName()));
                    ++n2;
                }
            }
            return actionList;
        }
        catch (RemoteException e) {
            throw new RemoteApiException(e.toString(), e);
        }
        catch (ClassCastException e) {
            throw new RemoteApiException(e.toString(), e);
        }
        catch (Exception e) {
            if (e instanceof SAXException && this.logger != null) {
                this.logger.warn("Soap method 'getSecurityLevel' thrown SAXException. Probably some JIRA error.", e);
            }
            throw new RemoteApiException(e);
        }
    }

    @Override
    public List<JIRASecurityLevelBean> getSecurityLevels(String projectKey) throws RemoteApiException {
        ArrayList<JIRASecurityLevelBean> levels = new ArrayList<JIRASecurityLevelBean>();
        try {
            RemoteSecurityLevel[] remoteSecurityLevels;
            RemoteSecurityLevel[] remoteSecurityLevelArray = remoteSecurityLevels = this.service.getSecurityLevels(this.token, projectKey);
            int n = remoteSecurityLevels.length;
            int n2 = 0;
            while (n2 < n) {
                RemoteSecurityLevel remoteLevel = remoteSecurityLevelArray[n2];
                levels.add(new JIRASecurityLevelBean(Long.valueOf(remoteLevel.getId()), remoteLevel.getName()));
                ++n2;
            }
        }
        catch (RemoteException e) {
            throw new RemoteApiException(e);
        }
        return levels;
    }

    @Override
    public List<JIRAActionField> getFieldsForAction(JIRAIssue issue, JIRAAction action) throws RemoteApiException {
        try {
            RemoteField[] fields = this.service.getFieldsForAction(this.token, issue.getKey(), Long.valueOf(action.getId()).toString());
            ArrayList<JIRAActionField> fieldList = new ArrayList<JIRAActionField>(fields.length);
            RemoteField[] remoteFieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                RemoteField f = remoteFieldArray[n2];
                fieldList.add(new JIRAActionFieldBean(f.getId(), f.getName()));
                ++n2;
            }
            return fieldList;
        }
        catch (RemoteException e) {
            throw new RemoteApiException(e.toString(), e);
        }
    }

    @Override
    public void progressWorkflowAction(JIRAIssue issue, JIRAAction action, List<JIRAActionField> fields) throws RemoteApiException {
        try {
            if (fields == null) {
                RemoteFieldValue[] dummyValues = new RemoteFieldValue[]{};
                this.service.progressWorkflowAction(this.token, issue.getKey(), String.valueOf(action.getId()), dummyValues);
            } else {
                CopyOnWriteArrayList<JIRAActionField> safeFields = new CopyOnWriteArrayList<JIRAActionField>(fields);
                for (JIRAActionField field : safeFields) {
                    if (field.getValues() != null) continue;
                    safeFields.remove(field);
                }
                int i = 0;
                RemoteFieldValue[] values = new RemoteFieldValue[safeFields.size()];
                for (JIRAActionField field : safeFields) {
                    List<String> fieldValues = field.getValues();
                    String[] fieldValueTable = fieldValues.toArray(new String[fieldValues.size()]);
                    values[i] = new RemoteFieldValue(field.getFieldId(), fieldValueTable);
                    ++i;
                }
                this.service.progressWorkflowAction(this.token, issue.getKey(), String.valueOf(action.getId()), values);
            }
        }
        catch (RemoteException e) {
            throw new RemoteApiException(e.toString(), e);
        }
    }

    @Override
    public List<JIRAComment> getComments(JIRAIssue issue) throws RemoteApiException {
        try {
            RemoteComment[] comments = this.service.getComments(this.token, issue.getKey());
            if (comments == null) {
                throw new RemoteApiException("Unable to retrieve comments");
            }
            ArrayList<JIRAComment> commentsList = new ArrayList<JIRAComment>(comments.length);
            RemoteComment[] remoteCommentArray = comments;
            int n = comments.length;
            int n2 = 0;
            while (n2 < n) {
                RemoteComment c = remoteCommentArray[n2];
                commentsList.add(new JIRACommentBean(c.getId(), c.getAuthor(), c.getBody(), c.getCreated()));
                ++n2;
            }
            return commentsList;
        }
        catch (RemoteException e) {
            throw new RemoteApiException(e.toString(), e);
        }
        catch (IllegalArgumentException e) {
            throw new RemoteApiException(e.toString(), e);
        }
    }

    @Override
    public JIRAUserBean getUser(String loginName) throws RemoteApiException, JiraUserNotFoundException {
        try {
            RemoteUser ru = this.service.getUser(this.token, loginName);
            if (ru == null) {
                throw new JiraUserNotFoundException("User Name for " + loginName + " not found");
            }
            return new JIRAUserBean(-1L, ru.getFullname(), ru.getName()){

                public String getQueryStringFragment() {
                    return null;
                }

                public JIRAQueryFragment getClone() {
                    return null;
                }
            };
        }
        catch (RemoteException e) {
            throw new RemoteApiException(e.toString(), e);
        }
        catch (ClassCastException e) {
            throw new RemoteApiException(e.toString(), e);
        }
    }

    @Override
    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    @Override
    public Collection<JIRAAttachment> getIssueAttachements(JIRAIssue issue) throws RemoteApiException {
        try {
            RemoteAttachment[] attachements = this.service.getAttachmentsFromIssue(this.token, issue.getKey());
            ArrayList<JIRAAttachment> attachmentList = new ArrayList<JIRAAttachment>(attachements != null ? attachements.length : 0);
            if (attachements != null) {
                RemoteAttachment[] remoteAttachmentArray = attachements;
                int n = attachements.length;
                int n2 = 0;
                while (n2 < n) {
                    RemoteAttachment a = remoteAttachmentArray[n2];
                    attachmentList.add(new JIRAAttachment(a.getId(), a.getAuthor(), a.getFilename(), a.getFilesize(), a.getMimetype(), a.getCreated()));
                    ++n2;
                }
            }
            return attachmentList;
        }
        catch (RemoteException e) {
            throw new RemoteApiException(e.toString(), e);
        }
        catch (ClassCastException e) {
            throw new RemoteApiException("Soap axis remote request failed to properly cast response while acquiring issue attachments", e);
        }
        catch (Exception e) {
            if (e.getMessage().contains("Bad types")) {
                throw new RemoteApiException("Soap axis remote request failed to properly cast response while acquiring issue attachments", e);
            }
            throw new RemoteApiException(e.toString(), e);
        }
    }
}

