/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.springframework.ide.eclipse.core.SpringCoreUtils;

public class NewWebflowConfigFilePage
extends WizardNewFileCreationPage {
    private Button swf2Button;
    private Button addNature;

    public NewWebflowConfigFilePage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
        this.setTitle("New Web Flow Definition file");
        this.setDescription("Select the location and give a name for the new Spring Web Flow Definition file");
    }

    protected InputStream getInitialContents() {
        try {
            return this.createXMLDocument();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected InputStream createXMLDocument() throws Exception {
        IPath containerPath = this.getContainerFullPath();
        IPath newFilePath = containerPath.append(this.getFileName());
        IFile newFileHandle = this.createFileHandle(newFilePath);
        String lineSeparator = SpringCoreUtils.getLineSeparator(null, (IProject)newFileHandle.getProject());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        String charSet = this.getUserPreferredCharset();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)outputStream, charSet));
        writer.println("<?xml version=\"1.0\" encoding=\"" + charSet + "\"?>");
        StringBuilder builder = new StringBuilder().append("<flow xmlns=\"http://www.springframework.org/schema/webflow\"").append(lineSeparator).append("\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"").append(lineSeparator).append("\txsi:schemaLocation=\"http://www.springframework.org/schema/webflow").append(lineSeparator);
        if (this.swf2Button.getSelection()) {
            builder.append("        http://www.springframework.org/schema/webflow/spring-webflow-2.0.xsd\">");
        } else {
            builder.append("        http://www.springframework.org/schema/webflow/spring-webflow-1.0.xsd\">");
        }
        builder.append(lineSeparator).append(lineSeparator);
        if (!this.swf2Button.getSelection()) {
            builder.append("\t<start-state idref=\"start\" />").append(lineSeparator).append(lineSeparator);
        }
        builder.append("\t<view-state id=\"start\">").append(lineSeparator).append("\t</view-state>").append(lineSeparator).append(lineSeparator).append("</flow>");
        writer.write(builder.toString());
        writer.flush();
        outputStream.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        return inputStream;
    }

    private String getUserPreferredCharset() {
        Preferences preference = XMLCorePlugin.getDefault().getPluginPreferences();
        String charSet = preference.getString("outputCodeset");
        return charSet;
    }

    protected void createAdvancedControls(Composite parent) {
        super.createAdvancedControls(parent);
        this.swf2Button = new Button(parent, 32);
        this.swf2Button.setText("Use Spring Web Flow 2 flow definition syntax (Required if you want to use Spring Web Flow 2)");
        this.swf2Button.setSelection(true);
        this.addNature = new Button(parent, 32);
        this.addNature.setText("Add Spring project nature if required");
        this.addNature.setSelection(true);
        this.addNature.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewWebflowConfigFilePage.this.validatePage();
            }
        });
    }

    protected boolean validatePage() {
        IPath path;
        if (super.validatePage() && (path = this.getContainerFullPath()) != null && path.segment(0) != null) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
            if (!SpringCoreUtils.isSpringProject((IResource)project) && !this.addNature.getSelection()) {
                this.setErrorMessage("Selected folder does not belong to a Spring project.");
                return false;
            }
            return true;
        }
        return false;
    }
}

