/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.properties;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.ui.SpringUIUtils;
import org.springframework.ide.eclipse.ui.viewers.JavaFileSuffixFilter;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowConfig;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelUtils;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowProject;
import org.springframework.ide.eclipse.webflow.ui.Activator;
import org.springframework.ide.eclipse.webflow.ui.navigator.WebflowNavigatorLabelProvider;
import org.springframework.ide.eclipse.webflow.ui.properties.FileSelectionValidator;
import org.springframework.ide.eclipse.webflow.ui.properties.WebflowConfigDialog;
import org.springframework.ide.eclipse.webflow.ui.properties.WebflowConfigLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebflowConfigTab {
    private static final int TABLE_WIDTH = 250;
    private static final String DESCRIPTION = "ConfigurationPropertyPage.tabConfigFiles.description";
    private static final String ADD_BUTTON = "ConfigurationPropertyPage.tabConfigFiles.addButton";
    private static final String REMOVE_BUTTON = "ConfigurationPropertyPage.tabConfigFiles.removeButton";
    private static final String DIALOG_TITLE = "ConfigurationPropertyPage.tabConfigFiles.addConfigDialog.title";
    private static final String DIALOG_MESSAGE = "ConfigurationPropertyPage.tabConfigFiles.addConfigDialog.message";
    private static final String EDIT_BUTTON = "ConfigurationPropertyPage.tabConfigFiles.editButton";
    private static final String SCAN_BUTTON = "ConfigurationPropertyPage.tabConfigFiles.scanButton";
    private static final String SCAN_NOTE_LABEL = "ConfigurationPropertyPage.tabConfigFiles.scan.note.label";
    private IAdaptable element;
    private Table configsTable;
    private TableViewer configsViewer;
    private Button addButton;
    private Button removeButton;
    private Button scanButton;
    private SelectionListener buttonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            WebflowConfigTab.this.handleButtonPressed((Button)e.widget);
        }
    };
    private boolean hasUserMadeChanges;
    private IWebflowProject project;
    private Set<IWebflowConfig> configFiles;
    private Map<IWebflowConfig, Set<IModelElement>> configFilesToBeansConfigs;
    private Map<IWebflowConfig, String> configFilesToNames;
    private IModelElement selectedElement;
    private Button editButton;

    public WebflowConfigTab(IWebflowProject project, IAdaptable element, IModelElement selectedModelElement) {
        this.project = project;
        this.element = element;
        this.configFiles = new LinkedHashSet<IWebflowConfig>();
        this.configFilesToBeansConfigs = new HashMap<IWebflowConfig, Set<IModelElement>>();
        this.configFilesToNames = new HashMap<IWebflowConfig, String>();
        if (project.getConfigs() != null) {
            for (IWebflowConfig config : project.getConfigs()) {
                this.configFiles.add(config);
                this.configFilesToBeansConfigs.put(config, config.getBeansConfigs());
                this.configFilesToNames.put(config, config.getName());
            }
        }
        if (selectedModelElement != null) {
            for (IWebflowConfig config : this.configFiles) {
                if (!config.getElementName().equals(selectedModelElement.getElementName())) continue;
                this.selectedElement = config;
            }
        }
    }

    public boolean hasUserMadeChanges() {
        return this.hasUserMadeChanges;
    }

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label description = new Label(composite, 64);
        description.setText(Activator.getResourceString(DESCRIPTION));
        description.setLayoutData((Object)new GridData(768));
        Composite tableAndButtons = new Composite(composite, 0);
        tableAndButtons.setLayoutData((Object)new GridData(1808));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        tableAndButtons.setLayout((Layout)layout);
        this.configsTable = new Table(tableAndButtons, 68354);
        GridData data = new GridData(1808);
        data.widthHint = 250;
        this.configsTable.setLayoutData((Object)data);
        this.configsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebflowConfigTab.this.handleTableSelectionChanged();
            }
        });
        this.configsViewer = new TableViewer(this.configsTable);
        this.configsViewer.setContentProvider((IContentProvider)new ConfigFilesContentProvider(this.configFiles));
        this.configsViewer.setLabelProvider((IBaseLabelProvider)new WebflowNavigatorLabelProvider());
        this.configsViewer.setInput(this.configFiles);
        this.configsViewer.setSorter((ViewerSorter)new ConfigFilesSorter());
        this.configsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                WebflowConfigTab.this.handleDoubleClick(event);
            }
        });
        if (this.selectedElement != null) {
            this.configsViewer.setSelection((ISelection)new StructuredSelection((Object)this.selectedElement), true);
        }
        Composite buttonArea = new Composite(tableAndButtons, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonArea.setLayout((Layout)layout);
        buttonArea.setLayoutData((Object)new GridData(1040));
        this.addButton = SpringUIUtils.createButton((Composite)buttonArea, (String)Activator.getResourceString(ADD_BUTTON), (SelectionListener)this.buttonListener, (int)0, (boolean)true);
        this.editButton = SpringUIUtils.createButton((Composite)buttonArea, (String)Activator.getResourceString(EDIT_BUTTON), (SelectionListener)this.buttonListener, (int)0, (boolean)false);
        this.removeButton = SpringUIUtils.createButton((Composite)buttonArea, (String)Activator.getResourceString(REMOVE_BUTTON), (SelectionListener)this.buttonListener, (int)0, (boolean)false);
        this.scanButton = SpringUIUtils.createButton((Composite)buttonArea, (String)Activator.getResourceString(SCAN_BUTTON), (SelectionListener)this.buttonListener, (int)0, (boolean)true);
        this.handleTableSelectionChanged();
        return composite;
    }

    private void handleDoubleClick(DoubleClickEvent event) {
        Object elem;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && (elem = ((IStructuredSelection)selection).getFirstElement()) instanceof IWebflowConfig) {
            this.handleEditButtonPressed();
        }
    }

    private void handleTableSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.configsViewer.getSelection();
        if (selection.isEmpty()) {
            this.removeButton.setEnabled(false);
            this.editButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
            this.editButton.setEnabled(true);
        }
    }

    private void handleButtonPressed(Button button) {
        if (button == this.addButton) {
            this.handleAddButtonPressed();
        } else if (button == this.removeButton) {
            this.handleRemoveButtonPressed();
        } else if (button == this.editButton) {
            this.handleEditButtonPressed();
        } else if (button == this.scanButton) {
            this.handleScanButtonPressed();
        }
        this.handleTableSelectionChanged();
        this.configsTable.setFocus();
    }

    private void handleEditButtonPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.configsViewer.getSelection();
        if (!selection.isEmpty()) {
            WebflowConfigDialog dialog;
            IWebflowConfig file = (IWebflowConfig)selection.getFirstElement();
            HashSet<IModelElement> configs = new HashSet<IModelElement>();
            String name = file.getName();
            ArrayList<String> names = new ArrayList<String>();
            names.add(name);
            if (this.configFilesToBeansConfigs.containsKey(file)) {
                Set<IModelElement> oldConfigs = this.configFilesToBeansConfigs.get(file);
                configs.addAll(oldConfigs);
            }
            if ((dialog = new WebflowConfigDialog(SpringUIUtils.getStandardDisplay().getActiveShell(), this.project.getProject(), configs, names, file.getResource())).open() == 0) {
                this.configFilesToBeansConfigs.put(file, configs);
                this.configFilesToNames.put(file, (String)names.get(0));
                this.hasUserMadeChanges = true;
            }
        }
        this.configsViewer.refresh();
    }

    private void handleAddButtonPressed() {
        Object[] selection;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(SpringUIUtils.getStandardDisplay().getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(Activator.getResourceString(DIALOG_TITLE));
        dialog.setMessage(Activator.getResourceString(DIALOG_MESSAGE));
        dialog.addFilter((ViewerFilter)new ConfigFileFilter(new String[]{"xml"}));
        dialog.setValidator((ISelectionStatusValidator)new FileSelectionValidator(true));
        dialog.setInput((Object)this.element);
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        if (dialog.open() == 0 && (selection = dialog.getResult()) != null && selection.length > 0) {
            int i = 0;
            while (i < selection.length) {
                IFile file = (IFile)selection[i];
                WebflowConfig config = new WebflowConfig(this.project);
                config.setResource(file);
                int j = file.getName().lastIndexOf(46);
                if (j > 0) {
                    config.setName(file.getName().substring(0, j));
                } else {
                    config.setName(file.getName());
                }
                this.configFiles.add((IWebflowConfig)config);
                ++i;
            }
            this.hasUserMadeChanges = true;
            this.configsViewer.refresh();
        }
    }

    private void handleRemoveButtonPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.configsViewer.getSelection();
        if (!selection.isEmpty()) {
            Iterator elements = selection.iterator();
            while (elements.hasNext()) {
                this.configFiles.remove((IWebflowConfig)elements.next());
            }
            this.configsViewer.refresh();
            this.hasUserMadeChanges = true;
        }
    }

    private void handleScanButtonPressed() {
        Object[] selection;
        ScannedFilesContentProvider contentProvider = new ScannedFilesContentProvider("xml");
        CheckedTreeSelectionDialog dialog = new CheckedTreeSelectionDialog(SpringUIUtils.getStandardDisplay().getActiveShell(), (ILabelProvider)new ScannedFilesLabelProvider(), contentProvider){

            protected Control createDialogArea(Composite parent) {
                Composite composite = (Composite)super.createDialogArea(parent);
                Label note = new Label(composite, 64);
                note.setText(Activator.getResourceString(WebflowConfigTab.SCAN_NOTE_LABEL));
                note.setLayoutData((Object)new GridData(768));
                return composite;
            }
        };
        dialog.setTitle(Activator.getResourceString(DIALOG_TITLE));
        dialog.setMessage(Activator.getResourceString(DIALOG_MESSAGE));
        dialog.addFilter((ViewerFilter)new ConfigFileFilter(new String[]{"xml"}));
        dialog.setValidator((ISelectionStatusValidator)new FileSelectionValidator(true));
        dialog.setInput((Object)this.element);
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        dialog.setInitialSelections(contentProvider.getElements(this.project.getProject()));
        if (dialog.open() == 0 && (selection = dialog.getResult()) != null && selection.length > 0) {
            int i = 0;
            while (i < selection.length) {
                IFile file = (IFile)selection[i];
                WebflowConfig config = new WebflowConfig(this.project);
                config.setResource(file);
                int j = file.getName().lastIndexOf(46);
                if (j > 0) {
                    config.setName(file.getName().substring(0, j));
                } else {
                    config.setName(file.getName());
                }
                this.configFiles.add((IWebflowConfig)config);
                ++i;
            }
            this.hasUserMadeChanges = true;
            this.configsViewer.refresh();
        }
    }

    public Map<IWebflowConfig, Set<IModelElement>> getConfigFilesToBeansConfigs() {
        return this.configFilesToBeansConfigs;
    }

    public void setConfigFiles(Set<IWebflowConfig> configFiles) {
        this.configFiles = configFiles;
    }

    public Set<IWebflowConfig> getConfigFiles() {
        return this.configFiles;
    }

    public Map<IWebflowConfig, String> getConfigFilesToNames() {
        return this.configFilesToNames;
    }

    private static class ConfigFileFilter
    extends JavaFileSuffixFilter {
        public ConfigFileFilter(String[] allowedFileExtensions) {
            super(allowedFileExtensions);
        }

        protected boolean selectFile(IFile element) {
            return !WebflowModelUtils.isWebflowConfig((IResource)element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConfigFilesContentProvider
    implements IStructuredContentProvider {
        private Set<IWebflowConfig> files;

        public ConfigFilesContentProvider(Set<IWebflowConfig> files) {
            this.files = files;
        }

        public Object[] getElements(Object obj) {
            return this.files.toArray();
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }

        public void dispose() {
        }
    }

    private class ConfigFilesSorter
    extends ViewerSorter {
        public static final int SUB_DIR = 0;
        public static final int ROOT_DIR = 1;

        private ConfigFilesSorter() {
        }

        public int category(Object element) {
            return ((IWebflowConfig)element).getResource().getName().indexOf(47) == -1 ? 1 : 0;
        }
    }

    private final class ScannedFilesContentProvider
    implements ITreeContentProvider {
        private Object[] scannedFiles = null;

        public ScannedFilesContentProvider(final String fileSuffixes) {
            final LinkedHashSet files = new LinkedHashSet();
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    WebflowConfigLocator locator = new WebflowConfigLocator(fileSuffixes);
                    files.addAll(locator.locateBeansConfigs(WebflowConfigTab.this.project.getProject(), monitor));
                }
            };
            try {
                ProgressMonitorDialog context = new ProgressMonitorDialog(SpringUIUtils.getStandardDisplay().getActiveShell());
                context.run(true, true, runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
            this.scannedFiles = files.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.scannedFiles;
        }

        public Object[] getChildren(Object parentElement) {
            return IWebflowModelElement.NO_CHILDREN;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private class ScannedFilesLabelProvider
    extends JavaElementLabelProvider {
        private ScannedFilesLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IFile) {
                return ((IFile)element).getProjectRelativePath().toString();
            }
            return super.getText(element);
        }
    }
}

