/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.navigator.filters;

import java.util.Collection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IProfileAwareBeansComponent;
import org.springframework.util.CollectionUtils;

public class NonMatchingProfilesFilter
extends ViewerFilter {
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof IProfileAwareBeansComponent) {
            IProfileAwareBeansComponent profileAwareBeansComponent = (IProfileAwareBeansComponent)element;
            IBeansConfigSet configSet = this.extractBeansConfigs((TreePath)parentElement);
            if (configSet == null) {
                return true;
            }
            if (!profileAwareBeansComponent.hasProfiles()) {
                return true;
            }
            return CollectionUtils.containsAny((Collection)profileAwareBeansComponent.getProfiles(), (Collection)configSet.getProfiles());
        }
        return true;
    }

    private IBeansConfigSet extractBeansConfigs(TreePath path) {
        int i = 0;
        while (i < path.getSegmentCount()) {
            Object obj = path.getSegment(i);
            if (obj instanceof IBeansConfigSet) {
                return (IBeansConfigSet)obj;
            }
            ++i;
        }
        return null;
    }
}

