/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.navigator.actions;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.ui.BeansUIUtils;
import org.springframework.ide.eclipse.core.io.ZipEntryStorage;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.ui.navigator.actions.AbstractNavigatorAction;

public class OpenPropertiesAction
extends AbstractNavigatorAction {
    private IProject project;
    private int block = 0;
    private IModelElement modelElement;

    public OpenPropertiesAction(ICommonActionExtensionSite site) {
        super(site);
        this.setText("&Properties");
    }

    public boolean isEnabled(IStructuredSelection selection) {
        ITreeSelection tSelection;
        if (selection instanceof ITreeSelection && (tSelection = (ITreeSelection)selection).size() == 1) {
            Object tElement = tSelection.getFirstElement();
            IModelElement element = null;
            if (tElement instanceof IModelElement) {
                element = (IModelElement)tElement;
            } else if (tElement instanceof IFile) {
                if ("org.springframework.ide.eclipse.beans.ui.navigator.springExplorerContent".equals(this.getActionSite().getExtensionId())) {
                    element = BeansCorePlugin.getModel().getConfig((IFile)tElement);
                }
            } else if (tElement instanceof ZipEntryStorage) {
                element = BeansModelUtils.getConfig((ZipEntryStorage)((ZipEntryStorage)tElement));
            }
            if (element != null) {
                this.project = element instanceof IResourceModelElement ? ((IResourceModelElement)element).getElementResource().getProject() : BeansModelUtils.getProject((IModelElement)element).getProject();
                this.block = this.getProjectPropertyPageBlock(tSelection.getPaths()[0]);
                this.modelElement = element;
                return true;
            }
        }
        return false;
    }

    public void run() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("org.springframework.ide.eclipse.beans.ui.properties.ProjectPropertyPage.blockId", this.block);
        data.put("org.springframework.ide.eclipse.beans.ui.properties.ProjectPropertyPage.selectedResource", this.modelElement);
        BeansUIUtils.showProjectPropertyPage(this.project, data);
    }

    private int getProjectPropertyPageBlock(TreePath path) {
        int i = path.getSegmentCount() - 1;
        while (i > 0) {
            Object segment = path.getSegment(i);
            if (segment instanceof IBeansConfigSet) {
                return 1;
            }
            --i;
        }
        return 0;
    }
}

