/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.navigator.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.springframework.ide.eclipse.beans.ui.BeansUIUtils;
import org.springframework.ide.eclipse.beans.ui.navigator.actions.OpenConfigFileAction;
import org.springframework.ide.eclipse.beans.ui.navigator.actions.OpenJavaElementAction;
import org.springframework.ide.eclipse.ui.navigator.actions.AbstractNavigatorAction;

public class OpenActionWrapperAction
extends AbstractNavigatorAction {
    private OpenConfigFileAction openConfigFileAction;
    private OpenJavaElementAction openJavaElementAction;
    private Action action;

    public OpenActionWrapperAction(ICommonActionExtensionSite site, OpenConfigFileAction openConfigFileAction, OpenJavaElementAction openJavaElementAction) {
        super(site);
        this.openConfigFileAction = openConfigFileAction;
        this.openJavaElementAction = openJavaElementAction;
        this.setText("Op&en");
    }

    public boolean isEnabled(IStructuredSelection selection) {
        if (selection.size() == 1) {
            boolean javaActionCanRun = this.openJavaElementAction.isEnabled(selection);
            boolean configActionCanRun = this.openConfigFileAction.isEnabled(selection);
            if (BeansUIUtils.shouldOpenConfigFile()) {
                if (configActionCanRun) {
                    this.action = this.openConfigFileAction;
                    return true;
                }
                if (javaActionCanRun) {
                    this.action = this.openJavaElementAction;
                    return true;
                }
                return false;
            }
            if (javaActionCanRun) {
                this.action = this.openJavaElementAction;
                return true;
            }
            if (configActionCanRun) {
                this.action = this.openConfigFileAction;
                return true;
            }
            return false;
        }
        return false;
    }

    public void run() {
        this.action.run();
    }
}

