/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.navigator;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.springframework.ide.eclipse.beans.ui.navigator.actions.OpenActionWrapperAction;
import org.springframework.ide.eclipse.beans.ui.navigator.actions.OpenConfigFileAction;
import org.springframework.ide.eclipse.beans.ui.navigator.actions.OpenJavaElementAction;
import org.springframework.ide.eclipse.beans.ui.navigator.actions.OpenPropertiesAction;
import org.springframework.ide.eclipse.beans.ui.navigator.actions.OpenReferenceAction;
import org.springframework.ide.eclipse.ui.navigator.actions.ValidationAction;

public class BeansNavigatorActionProvider
extends CommonActionProvider {
    private OpenConfigFileAction openConfigAction;
    private OpenReferenceAction openReferenceAction;
    private OpenJavaElementAction openElementAction;
    private OpenPropertiesAction openPropertiesAction;
    private OpenActionWrapperAction openAction;
    private ValidationAction validationAction;

    public void init(ICommonActionExtensionSite site) {
        this.openConfigAction = new OpenConfigFileAction(site);
        this.openReferenceAction = new OpenReferenceAction(site);
        this.openElementAction = new OpenJavaElementAction(site);
        this.openPropertiesAction = new OpenPropertiesAction(site);
        this.openAction = new OpenActionWrapperAction(site, this.openConfigAction, this.openElementAction);
        this.validationAction = new ValidationAction(site);
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.openConfigAction.isEnabled()) {
            menu.appendToGroup("group.open", (IAction)this.openConfigAction);
        }
        if (this.openReferenceAction.isEnabled()) {
            menu.appendToGroup("group.open", (IAction)this.openReferenceAction);
        }
        if (this.openElementAction.isEnabled()) {
            menu.appendToGroup("group.open", (IAction)this.openElementAction);
        }
        if (this.validationAction.isEnabled()) {
            menu.appendToGroup("group.build", (IAction)this.validationAction);
        }
        if (this.openPropertiesAction.isEnabled()) {
            menu.appendToGroup("group.properties", (IAction)this.openPropertiesAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        if (this.openAction.isEnabled()) {
            actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openAction);
        }
        if (this.openPropertiesAction.isEnabled()) {
            actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.openPropertiesAction);
        }
    }
}

