/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.namespaces;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.navigator.IDescriptionProvider;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansComponent;
import org.springframework.ide.eclipse.beans.core.model.INamespaceDefinition;
import org.springframework.ide.eclipse.beans.core.model.IProfileAwareBeansComponent;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelImages;
import org.springframework.ide.eclipse.beans.ui.namespaces.DefaultNamespaceLabels;
import org.springframework.ide.eclipse.beans.ui.namespaces.INamespaceLabelProvider;
import org.springframework.ide.eclipse.beans.ui.namespaces.NamespaceUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;

public class DefaultNamespaceLabelProvider
implements INamespaceLabelProvider,
ITreePathLabelProvider,
IDescriptionProvider {
    public Image getImage(ISourceModelElement element, IModelElement context, boolean isDecorating) {
        String namespaceUri = NamespaceUtils.getNameSpaceURI(element);
        if (element instanceof IBean && !"http://www.springframework.org/schema/beans".equals(namespaceUri) && !BeansModelUtils.isInnerBean((IBean)((IBean)element))) {
            Image image = null;
            INamespaceDefinition namespaceDefinition = BeansCorePlugin.getNamespaceDefinitionResolver((IProject)BeansModelUtils.getProject((IModelElement)element).getProject()).resolveNamespaceDefinition(namespaceUri);
            image = namespaceDefinition != null && namespaceDefinition.getIconPath() != null ? NamespaceUtils.getImage(namespaceDefinition) : BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.namespace_bean_obj.gif");
            if (isDecorating) {
                image = BeansModelImages.getDecoratedImage(image, (IModelElement)element, context);
            }
            return image;
        }
        if (element instanceof IProfileAwareBeansComponent) {
            Image image = BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.config_obj.gif");
            if (isDecorating) {
                image = BeansModelImages.getDecoratedImage(image, (IModelElement)element, context);
            }
            return image;
        }
        if (element instanceof IBeansComponent) {
            Image image = null;
            INamespaceDefinition namespaceDefinition = BeansCorePlugin.getNamespaceDefinitionResolver((IProject)BeansModelUtils.getProject((IModelElement)element).getProject()).resolveNamespaceDefinition(namespaceUri);
            image = namespaceDefinition != null && namespaceDefinition.getIconPath() != null ? NamespaceUtils.getImage(namespaceDefinition) : BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.namespace_component_obj.gif");
            if (isDecorating) {
                image = BeansModelImages.getDecoratedImage(image, (IModelElement)element, context);
            }
            return image;
        }
        return BeansModelImages.getImage((IModelElement)element, context, isDecorating);
    }

    public String getText(ISourceModelElement element, IModelElement context, boolean isDecorating) {
        return this.getElementLabel(element, 0);
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void updateLabel(ViewerLabel label, TreePath elementPath) {
        Object element = elementPath.getLastSegment();
        if (element instanceof ISourceModelElement && elementPath.getSegmentCount() > 1) {
            Object parent = elementPath.getParentPath().getLastSegment();
            IModelElement context = parent instanceof IModelElement ? (IModelElement)parent : null;
            label.setImage(this.getImage((ISourceModelElement)element, context, false));
            label.setText(this.getText((ISourceModelElement)element, context, false));
        }
    }

    public String getDescription(Object element) {
        if (element instanceof ISourceModelElement) {
            return this.getElementLabel((ISourceModelElement)element, 6);
        }
        return null;
    }

    protected String getElementLabel(ISourceModelElement element, int flags) {
        return DefaultNamespaceLabels.getElementLabel((IModelElement)element, flags);
    }
}

