/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.model.metadata;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.metadata.BeansMetadataPlugin;
import org.springframework.ide.eclipse.beans.core.metadata.model.IBeanMetadata;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansComponent;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.model.metadata.BeanMetadataReference;
import org.springframework.ide.eclipse.beans.ui.model.metadata.IBeanMetadataContentProvider;
import org.springframework.ide.eclipse.beans.ui.model.metadata.IBeanMetadataLabelProvider;
import org.springframework.ide.eclipse.core.model.IModelElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanMetadataUtils {
    private static final String LABEL_PROVIDER_ATTRIBUTE = "labelProvider";
    private static final String CONTENT_PROVIDER_ATTRIBUTE = "contentProvider";
    private static final String METADATA_PROVIDERS_ELEMENT = "metadataProviders";
    private static final String PRIORITY_ATTRIBUTE = "priority";
    public static final String META_DATA_PROVIDERS_EXTENSION_POINT = "org.springframework.ide.eclipse.beans.ui.metadataproviders";

    public static IBeanMetadataContentProvider getContenProvider(IBeanMetadata metaDataReference) {
        IBeanMetadataContentProvider contentProvider = null;
        int priority = -1;
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(META_DATA_PROVIDERS_EXTENSION_POINT);
        if (point != null) {
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    if (METADATA_PROVIDERS_ELEMENT.equals(config.getName()) && config.getAttribute(CONTENT_PROVIDER_ATTRIBUTE) != null) {
                        try {
                            IBeanMetadataContentProvider provider;
                            Object handler;
                            int handlerPriority = BeanMetadataUtils.getPriority(config);
                            if (handlerPriority > priority && (handler = config.createExecutableExtension(CONTENT_PROVIDER_ATTRIBUTE)) instanceof IBeanMetadataContentProvider && (provider = (IBeanMetadataContentProvider)handler).supports(metaDataReference)) {
                                contentProvider = provider;
                                priority = handlerPriority;
                            }
                        }
                        catch (CoreException e) {
                            BeansUIPlugin.log(e);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return contentProvider;
    }

    public static IBeanMetadataLabelProvider getLabelProvider(BeanMetadataReference metaDataReference) {
        IBeanMetadataLabelProvider labelProvider = null;
        int priority = -1;
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(META_DATA_PROVIDERS_EXTENSION_POINT);
        if (point != null) {
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    if (METADATA_PROVIDERS_ELEMENT.equals(config.getName()) && config.getAttribute(LABEL_PROVIDER_ATTRIBUTE) != null) {
                        try {
                            IBeanMetadataLabelProvider provider;
                            Object handler;
                            int handlerPriority = BeanMetadataUtils.getPriority(config);
                            if (handlerPriority > priority && (handler = config.createExecutableExtension(LABEL_PROVIDER_ATTRIBUTE)) instanceof IBeanMetadataLabelProvider && (provider = (IBeanMetadataLabelProvider)handler).supports(metaDataReference)) {
                                labelProvider = provider;
                                priority = handlerPriority;
                            }
                        }
                        catch (CoreException e) {
                            BeansUIPlugin.log(e);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return labelProvider;
    }

    public static IBeanMetadataLabelProvider getLabelProvider(IBeanMetadata metaData) {
        IBeanMetadataLabelProvider labelProvider = null;
        int priority = -1;
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(META_DATA_PROVIDERS_EXTENSION_POINT);
        if (point != null) {
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    if (METADATA_PROVIDERS_ELEMENT.equals(config.getName()) && config.getAttribute(LABEL_PROVIDER_ATTRIBUTE) != null) {
                        try {
                            IBeanMetadataLabelProvider provider;
                            Object handler;
                            int handlerPriority = BeanMetadataUtils.getPriority(config);
                            if (handlerPriority > priority && (handler = config.createExecutableExtension(LABEL_PROVIDER_ATTRIBUTE)) instanceof IBeanMetadataLabelProvider && (provider = (IBeanMetadataLabelProvider)handler).supports(metaData)) {
                                labelProvider = provider;
                                priority = handlerPriority;
                            }
                        }
                        catch (CoreException e) {
                            BeansUIPlugin.log(e);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return labelProvider;
    }

    public static Collection<? extends Object> getProjectChildren(IBeansProject project) {
        HashMap<String, BeanMetadataReference> metaDataMapping = new HashMap<String, BeanMetadataReference>();
        for (IBeansConfig beansConfig : project.getConfigs()) {
            for (IBean bean : BeansModelUtils.getBeans((IModelElement)beansConfig)) {
                BeanMetadataUtils.addMetaDataForBean(project, metaDataMapping, bean);
            }
            for (IBeansComponent beansComponent : beansConfig.getComponents()) {
                for (IBean bean : BeansModelUtils.getBeans((IModelElement)beansComponent)) {
                    BeanMetadataUtils.addMetaDataForBean(project, metaDataMapping, bean);
                }
            }
        }
        return metaDataMapping.values();
    }

    private static void addMetaDataForBean(IBeansProject project, Map<String, BeanMetadataReference> metaDataMapping, IBean bean) {
        for (IBeanMetadata metaData : BeansMetadataPlugin.getMetadataModel().getBeanMetadata(bean)) {
            if (!metaDataMapping.containsKey(metaData.getKey())) {
                metaDataMapping.put(metaData.getKey(), BeanMetadataUtils.getContenProvider(metaData).getBeanMetadataReference(metaData, project));
            }
            metaDataMapping.get(metaData.getKey()).addChild(metaData);
        }
    }

    private static int getPriority(IConfigurationElement config) {
        int handlerPriority = 10;
        if (config.getAttribute(PRIORITY_ATTRIBUTE) != null) {
            handlerPriority = Integer.valueOf(config.getAttribute(PRIORITY_ATTRIBUTE));
        }
        return handlerPriority;
    }
}

