/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.refactoring.model;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfigSet;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansJavaConfig;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansProject;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansModel;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelLabelDecorator;

public class BeansJavaConfigTypeChange
extends Change {
    private IType type;
    private String newName;
    private IBeansModel beansModel;

    public BeansJavaConfigTypeChange(IType type, String newName) {
        this.type = type;
        this.newName = newName;
        this.setBeansModel(BeansCorePlugin.getModel());
    }

    public void setBeansModel(IBeansModel beansModel) {
        this.beansModel = beansModel;
    }

    public String getName() {
        return "Rename references to '" + this.type.getElementName() + "' in Spring project configurations";
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        if (pm.isCanceled()) {
            return null;
        }
        for (IBeansProject project : this.beansModel.getProjects()) {
            boolean updated = false;
            BeansProject beansProject = (BeansProject)project;
            for (IBeansConfigSet configSet : beansProject.getConfigSets()) {
                Set configs = configSet.getConfigs();
                for (IBeansConfig config : configs) {
                    if (!(config instanceof BeansJavaConfig)) continue;
                    IType configClass = ((BeansJavaConfig)config).getConfigClass();
                    if (this.type.equals(configClass)) {
                        ((BeansConfigSet)configSet).removeConfig(config.getElementName());
                        ((BeansConfigSet)configSet).addConfig("java:" + this.newName);
                        continue;
                    }
                    if (configClass == null || !this.type.equals(configClass.getDeclaringType())) continue;
                    beansProject.removeConfig(config.getElementName());
                    String newConfigClassName = String.valueOf(this.newName) + "$" + configClass.getElementName();
                    beansProject.addConfig("java:" + newConfigClassName, IBeansConfig.Type.MANUAL);
                }
            }
            for (IBeansConfig config : beansProject.getConfigs()) {
                IType configClass;
                if (!(config instanceof BeansJavaConfig) || (configClass = ((BeansJavaConfig)config).getConfigClass()) == null || this.getNewConfigName(this.newName, this.type, configClass) == null) continue;
                beansProject.removeConfig(config.getElementName());
                beansProject.addConfig("java:" + this.getNewConfigName(this.newName, this.type, configClass), IBeansConfig.Type.MANUAL);
                updated = true;
            }
            if (!updated) continue;
            ((BeansProject)project).saveDescription();
            BeansModelLabelDecorator.update();
        }
        return null;
    }

    protected String getNewConfigName(String newName, IType type, IType configClass) {
        if (type.equals(configClass)) {
            return newName;
        }
        IType walkingType = configClass.getDeclaringType();
        String walkingTypeName = configClass.getElementName();
        while (walkingType != null) {
            if (type.equals(walkingType)) {
                return String.valueOf(newName) + "$" + walkingTypeName;
            }
            walkingTypeName = String.valueOf(walkingType.getElementName()) + "$" + walkingTypeName;
            walkingType = walkingType.getDeclaringType();
        }
        return null;
    }

    public Object getModifiedElement() {
        return null;
    }
}

