/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.refactoring.ltk;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansImport;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.beans.ui.refactoring.ltk.RenameIdRefactoringDescriptor;
import org.springframework.ide.eclipse.beans.ui.refactoring.ltk.RenameIdType;
import org.springframework.ide.eclipse.beans.ui.refactoring.util.BeansRefactoringChangeUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameIdRefactoring
extends Refactoring {
    protected static final String ID_TYPE = "id-type";
    protected static final String FILE = "file";
    protected static final String NAME = "name";
    protected static final String OFFSET = "offset";
    protected static final String OLDNAME = "oldName";
    protected static final String REFERENCES = "references";
    private RenameIdType type;
    protected String beanId;
    protected IFile file;
    protected IDOMNode node;
    protected String oldBeanId;
    protected int offset;
    protected boolean updateReferences = true;

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        try {
            pm.beginTask("Creating change...", 1);
            CompositeChange compositeChange = new CompositeChange("Rename Spring " + this.type.getType() + " id"){

                public ChangeDescriptor getDescriptor() {
                    String project = RenameIdRefactoring.this.file.getProject().getName();
                    String description = MessageFormat.format("Rename Spring " + RenameIdRefactoring.this.type.getType() + " ''{0}''", RenameIdRefactoring.this.oldBeanId);
                    String comment = MessageFormat.format("Rename Spring " + RenameIdRefactoring.this.type.getType() + " from ''{0}'' to ''{1}''", RenameIdRefactoring.this.oldBeanId, RenameIdRefactoring.this.beanId);
                    HashMap<String, String> arguments = new HashMap<String, String>();
                    arguments.put(RenameIdRefactoring.OLDNAME, RenameIdRefactoring.this.oldBeanId);
                    arguments.put(RenameIdRefactoring.NAME, RenameIdRefactoring.this.beanId);
                    arguments.put(RenameIdRefactoring.ID_TYPE, RenameIdRefactoring.this.type.toString());
                    arguments.put(RenameIdRefactoring.FILE, RenameIdRefactoring.this.file.getFullPath().toString());
                    arguments.put(RenameIdRefactoring.REFERENCES, Boolean.valueOf(RenameIdRefactoring.this.updateReferences).toString());
                    arguments.put(RenameIdRefactoring.OFFSET, Integer.toString(RenameIdRefactoring.this.offset));
                    RenameIdRefactoringDescriptor idRefactoringDescriptor = new RenameIdRefactoringDescriptor(project, description, comment, arguments);
                    return new RefactoringChangeDescriptor((RefactoringDescriptor)idRefactoringDescriptor);
                }
            };
            Change change = BeansRefactoringChangeUtils.createRenameBeanIdChange(this.file, this.type, this.oldBeanId, this.beanId, this.updateReferences, pm);
            if (change != null) {
                compositeChange.add(change);
            }
            if (this.updateReferences) {
                this.addChangesForUpdatedReferences(this.type, compositeChange, pm);
            }
            CompositeChange compositeChange2 = compositeChange;
            return compositeChange2;
        }
        finally {
            pm.done();
        }
    }

    private void addChangesForUpdatedReferences(RenameIdType descriptor, CompositeChange compositeChange, IProgressMonitor pm) throws CoreException {
        IBeansConfig config = BeansCorePlugin.getModel().getConfig(this.file);
        if (config != null) {
            HashSet<IBeansConfig> visitedResources = new HashSet<IBeansConfig>();
            visitedResources.add(config);
            for (IBeansImport import_ : config.getImports()) {
                for (IBeansConfig bc : import_.getImportedBeansConfigs()) {
                    this.addChangesForUpdateReferences(bc, descriptor, compositeChange, visitedResources, pm);
                }
            }
            IBeansConfig importingBeansConfig = BeansModelUtils.getImportingBeansConfig((IBeansConfig)config);
            if (importingBeansConfig != null) {
                this.addChangesForUpdateReferences(importingBeansConfig, descriptor, compositeChange, visitedResources, pm);
            }
            for (IBeansProject project : BeansCorePlugin.getModel().getProjects()) {
                for (IBeansConfigSet configSet : project.getConfigSets()) {
                    if (!configSet.getConfigs().contains(config)) continue;
                    for (IBeansConfig bc : configSet.getConfigs()) {
                        this.addChangesForUpdateReferences(bc, descriptor, compositeChange, visitedResources, pm);
                    }
                }
            }
        }
    }

    private void addChangesForUpdateReferences(IBeansConfig beansConfig, RenameIdType descriptor, CompositeChange compositeChange, Set<IBeansConfig> visitedResources, IProgressMonitor pm) throws CoreException {
        IResource res;
        if (!visitedResources.contains(beansConfig) && !beansConfig.isElementArchived() && (res = beansConfig.getElementResource()).isAccessible() && res instanceof IFile) {
            visitedResources.add(beansConfig);
            TextFileChange refsChange = BeansRefactoringChangeUtils.createRenameBeanRefsChange((IFile)beansConfig.getElementResource(), descriptor, this.oldBeanId, this.beanId, pm);
            if (refsChange != null) {
                compositeChange.add((Change)refsChange);
            }
        }
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask("Checking preconditions...", 1);
            if (this.file == null) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)"Config file not given"));
            } else if (!this.file.exists()) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format("File ''{0}'' is not a Spring IDE Beans Config.", this.file.getFullPath().toString())));
            }
            if (this.node == null) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)"Selection not given"));
            } else if (!BeansEditorUtils.hasAttribute((Node)this.node, (String)"id")) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)"Selected XML element has no id"));
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        return status;
    }

    public RenameIdType getType() {
        return this.type;
    }

    public void setType(RenameIdType type) {
        this.type = type;
    }

    public String getName() {
        return "Rename " + (Object)((Object)this.type);
    }

    public String getBeanId() {
        if (this.beanId == null) {
            return BeansEditorUtils.getAttribute((Node)this.node, (String)"id");
        }
        return this.beanId;
    }

    public RefactoringStatus setBeanId(String beanId) {
        this.beanId = beanId;
        RefactoringStatus status = new RefactoringStatus();
        if (!StringUtils.hasText((String)beanId)) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)(String.valueOf(this.getType().getType()) + " id cannot be empty")));
        } else if (this.node != null && this.node.getOwnerDocument().getElementById(beanId) != null) {
            status.merge(RefactoringStatus.createInfoStatus((String)(String.valueOf(this.getType().getType()) + " id already used in current file")));
        }
        return status;
    }

    public void setFile(IFile file) {
        this.file = file;
    }

    public void setNode(IDOMNode node) {
        this.node = node;
        this.oldBeanId = BeansEditorUtils.getAttribute((Node)node, (String)"id");
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setUpdateReferences(boolean updateReferences) {
        this.updateReferences = updateReferences;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RefactoringStatus initialize(Map<String, String> arguments) {
        RefactoringStatus status = new RefactoringStatus();
        String value = arguments.get(ID_TYPE);
        if (value != null) {
            this.setType(RenameIdType.valueOf(value));
        }
        if ((value = arguments.get(REFERENCES)) != null) {
            this.setUpdateReferences(Boolean.valueOf(value));
        }
        if ((value = arguments.get(FILE)) != null) {
            IWorkspaceRoot container = ResourcesPlugin.getWorkspace().getRoot();
            IResource resource = container.findMember(value);
            if (resource == null || !(resource instanceof IFile)) {
                status.merge(RefactoringStatus.createErrorStatus((String)"Cannot get file"));
            } else {
                this.setFile((IFile)resource);
            }
        }
        if ((value = arguments.get(NAME)) != null) {
            this.setBeanId(value);
        }
        if ((value = arguments.get(OLDNAME)) != null) {
            this.oldBeanId = value;
        }
        if ((value = arguments.get(OFFSET)) == null) return status;
        int offset = Integer.valueOf(value);
        IStructuredModel model = null;
        try {
            try {
                model = StructuredModelManager.getModelManager().getModelForRead(this.file);
                IndexedRegion inode = model.getIndexedRegion(offset);
                if (inode == null) {
                    inode = model.getIndexedRegion(offset - 1);
                }
                if (!(inode instanceof IDOMNode)) return status;
                this.node = (IDOMNode)inode;
                return status;
            }
            catch (IOException iOException) {
                if (model == null) return status;
                model.releaseFromRead();
                return status;
            }
            catch (CoreException coreException) {
                if (model == null) return status;
                model.releaseFromRead();
                return status;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }
}

