/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.refactoring.actions;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ICreateTargetQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaMoveProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.reorg.CreateTargetQueries;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMoveWizard;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgQueries;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.MoveRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.widgets.Shell;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.refactoring.actions.AbstractBeansRefactorAction;
import org.springframework.ide.eclipse.beans.ui.refactoring.actions.RefactoringStarter;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.util.ClassUtils;

public class BeansMoveRefactorAction
extends AbstractBeansRefactorAction {
    protected void run(IJavaElement element) throws CoreException {
        if (!(element instanceof IType)) {
            return;
        }
        ArrayList<IJavaElement> elements = new ArrayList<IJavaElement>();
        elements.add(element);
        IResource[] resources = ReorgUtils.getResources(elements);
        IJavaElement[] javaElements = ReorgUtils.getJavaElements(elements);
        this.startRefactoring(resources, javaElements, BeansUIPlugin.getActiveWorkbenchShell());
    }

    protected void startRefactoring(IResource[] resources, IJavaElement[] javaElements, Shell shell) throws CoreException {
        IReorgPolicy.IMovePolicy policy;
        if (RefactoringAvailabilityTester.isMoveAvailable((IResource[])resources, (IJavaElement[])javaElements) && (policy = ReorgPolicyFactory.createMovePolicy((IResource[])resources, (IJavaElement[])javaElements)).canEnable()) {
            JavaMoveProcessor processor = new JavaMoveProcessor(policy);
            MoveRefactoring refactoring = new MoveRefactoring((MoveProcessor)processor);
            RefactoringWizard wizard = null;
            if (SpringCoreUtils.isEclipseSameOrNewer((int)3, (int)4)) {
                Constructor cons = ClassUtils.getConstructorIfAvailable(ReorgMoveWizard.class, (Class[])new Class[]{JavaMoveProcessor.class, Refactoring.class});
                if (cons != null) {
                    try {
                        wizard = (RefactoringWizard)cons.newInstance(processor, refactoring);
                    }
                    catch (Exception e) {
                        BeansUIPlugin.log((Throwable)e);
                    }
                }
            } else {
                Constructor cons = ClassUtils.getConstructorIfAvailable(ReorgMoveWizard.class, (Class[])new Class[]{Refactoring.class});
                if (cons != null) {
                    try {
                        wizard = (RefactoringWizard)cons.newInstance(refactoring);
                    }
                    catch (Exception e) {
                        BeansUIPlugin.log((Throwable)e);
                    }
                }
            }
            if (wizard != null) {
                processor.setCreateTargetQueries((ICreateTargetQueries)new CreateTargetQueries(wizard));
                processor.setReorgQueries((IReorgQueries)new ReorgQueries((Wizard)wizard));
                new RefactoringStarter().activate((Refactoring)refactoring, wizard, shell, RefactoringMessages.OpenRefactoringWizardAction_refactoring, 1);
            }
        }
    }
}

