/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.refactoring.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.beans.ui.actions.AbstractBeansConfigEditorHandler;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractBeansRefactorAction
extends AbstractBeansConfigEditorHandler {
    protected String getSelectedAttributeName(ITextSelection textSelection) {
        Object obj;
        String attributeName = null;
        if (textSelection instanceof IStructuredSelection && (obj = ((IStructuredSelection)textSelection).getFirstElement()) instanceof Element) {
            int offset = textSelection.getOffset() - ((IDOMNode)obj).getStartOffset();
            IStructuredDocumentRegion open = ((IDOMNode)obj).getFirstStructuredDocumentRegion();
            ITextRegionList openRegions = open.getRegions();
            ITextRegion nameRegion = null;
            int i = open.getNumberOfRegions() - 1;
            while (i >= 0) {
                ITextRegion region = openRegions.get(i);
                if (region.getStart() <= offset && region.getType() == "XML_TAG_ATTRIBUTE_NAME") {
                    nameRegion = region;
                    break;
                }
                --i;
            }
            if (nameRegion != null) {
                attributeName = open.getText(nameRegion);
            }
        }
        return attributeName;
    }

    protected void processAction(ExecutionEvent event, IDocument document, ITextSelection textSelection) {
        if (textSelection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)textSelection).getFirstElement();
            Element node = null;
            String attributeName = null;
            if (obj instanceof Attr) {
                Attr attribute = (Attr)obj;
                node = attribute.getOwnerElement();
                attributeName = attribute.getName();
            } else if (obj instanceof Element) {
                node = (Element)obj;
                attributeName = this.getSelectedAttributeName(textSelection);
            }
            if (node != null && attributeName != null) {
                String className = BeansEditorUtils.getAttribute((Node)node, (String)"class");
                String propertyName = BeansEditorUtils.getAttribute((Node)node, (String)"name");
                IType je = null;
                if ("bean".equals(node.getLocalName()) && StringUtils.hasText((String)className) && "class".equals(attributeName)) {
                    je = JdtUtils.getJavaType((IProject)BeansEditorUtils.getProject((IDocument)document), (String)className);
                } else if ("property".equals(node.getLocalName()) && StringUtils.hasText((String)propertyName) && "name".equals(attributeName)) {
                    Node beanNode = node.getParentNode();
                    List types = BeansEditorUtils.getClassNamesOfBean((IFile)this.getConfigFile(event), (Node)beanNode);
                    if (!(types == null || types.size() <= 0 || (je = ((IType)types.get(0)).getField(propertyName)) != null && je.exists())) {
                        ArrayList<String> path = new ArrayList<String>();
                        path.add(propertyName);
                        je = BeansEditorUtils.extractMethodFromPropertyPathElements(path, (List)types, (IFile)this.getConfigFile(event), (int)0);
                    }
                }
                try {
                    if (je != null) {
                        this.run((IJavaElement)je);
                    }
                }
                catch (CoreException coreException) {}
            }
        }
    }

    protected abstract void run(IJavaElement var1) throws CoreException;

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        IDocument document = this.getTextEditor(executionEvent).getDocumentProvider().getDocument((Object)this.getTextEditor(executionEvent).getEditorInput());
        if (document != null) {
            ITextSelection textSelection = this.getCurrentSelection(executionEvent);
            if (textSelection.isEmpty()) {
                return null;
            }
            this.processAction(executionEvent, document, textSelection);
        }
        return null;
    }
}

