/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.properties;

import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.springframework.ide.eclipse.webflow.core.model.ICloneableModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.graph.actions.EditPropertiesAction;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.EditPropertiesCommand;

public class AdvancedEditSection
extends AbstractPropertySection {
    private Button advancedEditButton;
    private IWebflowModelElement state;
    private IWebflowModelElement oldState;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.advancedEditButton = this.getWidgetFactory().createButton(composite, "Advanced...", 8);
        FormData data = new FormData();
        data.left = new FormAttachment(90, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.advancedEditButton.setLayoutData((Object)data);
        this.advancedEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                ActionRegistry actionRegistry = (ActionRegistry)editor.getAdapter(ActionRegistry.class);
                EditPropertiesAction action = (EditPropertiesAction)actionRegistry.getAction((Object)"Edit_propeties");
                action.setOpenDialog(true);
                EditPropertiesCommand command = new EditPropertiesCommand();
                IWebflowModelElement clone = null;
                if (AdvancedEditSection.this.state instanceof ICloneableModelElement) {
                    clone = ((ICloneableModelElement)AdvancedEditSection.this.state).cloneModelElement();
                }
                command.setChild((ICloneableModelElement<IWebflowModelElement>)((ICloneableModelElement)AdvancedEditSection.this.state), clone);
                if (action != null) {
                    action.runWithCommand(command);
                }
            }
        });
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof AbstractEditPart && ((AbstractEditPart)input).getModel() instanceof IWebflowModelElement) {
            this.oldState = this.state = (IWebflowModelElement)((AbstractEditPart)input).getModel();
        }
    }

    public void refresh() {
    }
}

