/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.policies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.swt.graphics.Color;
import org.springframework.ide.eclipse.webflow.ui.graph.figures.CompoundStateFigure;

public class StateContainerHighlightEditPolicy
extends GraphicalEditPolicy {
    private static Color highLightColor = new Color(null, 200, 200, 240);
    private Color revertColor;

    public void eraseTargetFeedback(Request request) {
        if (this.revertColor != null) {
            this.setContainerBackground(this.revertColor);
            this.revertColor = null;
        }
        if ((request.getType().equals("create child") || request.getType().equals("add children") || request.getType().equals("clone") || request.getType().equals("move") || request.getType().equals("connection start") || request.getType().equals("connection end")) && this.getContainerFigure() instanceof CompoundStateFigure) {
            ((CompoundStateFigure)this.getContainerFigure()).setSelected(false);
        }
    }

    private Color getContainerBackground() {
        return this.getContainerFigure().getBackgroundColor();
    }

    private IFigure getContainerFigure() {
        return ((GraphicalEditPart)this.getHost()).getFigure();
    }

    public EditPart getTargetEditPart(Request request) {
        return request.getType().equals("selection hover") ? this.getHost() : null;
    }

    private void setContainerBackground(Color c) {
        this.getContainerFigure().setBackgroundColor(c);
    }

    protected void showHighlight() {
        if (this.revertColor == null) {
            this.revertColor = this.getContainerBackground();
            this.setContainerBackground(highLightColor);
        }
    }

    public void showTargetFeedback(Request request) {
        if (request.getType().equals("create child") || request.getType().equals("add children") || request.getType().equals("clone") || request.getType().equals("move")) {
            if (this.getContainerFigure() instanceof CompoundStateFigure) {
                ((CompoundStateFigure)this.getContainerFigure()).setSelected(true);
            } else {
                this.showHighlight();
            }
        } else if ((request.getType().equals("connection start") || request.getType().equals("connection end")) && this.getContainerFigure() instanceof CompoundStateFigure) {
            ((CompoundStateFigure)this.getContainerFigure()).setSelected(true);
        }
    }
}

