/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.policies;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.ContainerEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.springframework.ide.eclipse.webflow.core.internal.model.SubflowState;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IActionState;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeMapper;
import org.springframework.ide.eclipse.webflow.core.model.IDecisionState;
import org.springframework.ide.eclipse.webflow.core.model.IExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.model.IIf;
import org.springframework.ide.eclipse.webflow.core.model.IInlineFlowState;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.ISubflowState;
import org.springframework.ide.eclipse.webflow.core.model.ITransitionableFrom;
import org.springframework.ide.eclipse.webflow.core.model.IViewState;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.ActionCloneCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.ActionOrphanChildCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.AttributeMapperCloneCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.AttributeMapperOrphanChildCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.ExceptionHandlerCloneCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.ExceptionHandlerOrphanChildCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.IfOrphanChildCommand;

public class StateContainerEditPolicy
extends ContainerEditPolicy {
    protected Command getCreateCommand(CreateRequest request) {
        return null;
    }

    protected Command getOrphanChildrenCommand(GroupRequest request) {
        List parts = request.getEditParts();
        CompoundCommand result = new CompoundCommand();
        int i = 0;
        while (i < parts.size()) {
            Command orphan;
            EditPart part = (EditPart)parts.get(i);
            if (part.getModel() instanceof IActionElement) {
                orphan = new ActionOrphanChildCommand();
                orphan.setChild((IActionElement)((EditPart)parts.get(i)).getModel());
                result.add(orphan);
            } else if (part.getModel() instanceof IExceptionHandler) {
                orphan = new ExceptionHandlerOrphanChildCommand();
                orphan.setChild((IExceptionHandler)((EditPart)parts.get(i)).getModel());
                result.add(orphan);
            } else if (part.getModel() instanceof IAttributeMapper) {
                orphan = new AttributeMapperOrphanChildCommand();
                orphan.setChild((IAttributeMapper)((EditPart)parts.get(i)).getModel());
                orphan.setParent((ISubflowState)this.getHost().getModel());
                result.add(orphan);
            } else if (part.getModel() instanceof IIf) {
                orphan = new IfOrphanChildCommand();
                orphan.setChild((IIf)((EditPart)parts.get(i)).getModel());
                orphan.setParent((IDecisionState)this.getHost().getModel());
                result.add(orphan);
            }
            ++i;
        }
        return result.unwrap();
    }

    protected Command getCloneCommand(ChangeBoundsRequest request) {
        List parts = request.getEditParts();
        CompoundCommand result = new CompoundCommand();
        int i = 0;
        while (i < parts.size()) {
            Command orphan;
            IState state;
            EditPart part = (EditPart)parts.get(i);
            if (part.getModel() instanceof IActionElement) {
                IActionElement ae = (IActionElement)part.getModel();
                IState state2 = (IState)this.getHost().getModel();
                if (ae.getType() == IActionElement.ACTION_TYPE.ACTION && state2 instanceof IActionState || ae.getType() == IActionElement.ACTION_TYPE.RENDER_ACTION && state2 instanceof IViewState || ae.getType() == IActionElement.ACTION_TYPE.ENTRY_ACTION && state2 instanceof IState || ae.getType() == IActionElement.ACTION_TYPE.EXIT_ACTION && state2 instanceof ITransitionableFrom) {
                    ActionCloneCommand orphan2 = new ActionCloneCommand();
                    orphan2.setChild((IActionElement)((EditPart)parts.get(i)).getModel());
                    orphan2.setNewState((IWebflowModelElement)this.getHost().getModel());
                    result.add((Command)orphan2);
                }
            } else if (part.getModel() instanceof IExceptionHandler) {
                state = (IState)this.getHost().getModel();
                if (!(state instanceof IWebflowState) && !(state instanceof IInlineFlowState)) {
                    orphan = new ExceptionHandlerCloneCommand();
                    orphan.setChild((IExceptionHandler)((EditPart)parts.get(i)).getModel());
                    orphan.setNewState((IWebflowModelElement)this.getHost().getModel());
                    result.add(orphan);
                }
            } else if (part.getModel() instanceof IAttributeMapper && (state = (IState)this.getHost().getModel()) instanceof SubflowState && ((SubflowState)state).getAttributeMapper() == null) {
                orphan = new AttributeMapperCloneCommand();
                orphan.setChild((IAttributeMapper)((EditPart)parts.get(i)).getModel());
                orphan.setNewState((IWebflowModelElement)this.getHost().getModel());
                result.add(orphan);
            }
            ++i;
        }
        return result.unwrap();
    }
}

