/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.IStateTransition;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;
import org.springframework.ide.eclipse.webflow.ui.graph.model.WebflowModelLabelProvider;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.AbstractStatePart;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.GraphAnimation;
import org.springframework.ide.eclipse.webflow.ui.graph.policies.TransitionEditPolicy;

public class StateTransitionPart
extends AbstractConnectionEditPart
implements PropertyChangeListener {
    private static final Color COLOR = new Color(null, 255, 255, 206);
    protected WebflowModelLabelProvider eLabelProvider = new WebflowModelLabelProvider();
    private PolylineConnection conn;
    private Label label;

    public void activate() {
        super.activate();
        ((IWebflowModelElement)this.getModel()).addPropertyChangeListener((PropertyChangeListener)this);
    }

    protected void applyGraphResults(CompoundDirectedGraph graph, Map map) {
        this.conn = (PolylineConnection)this.getConnectionFigure();
        this.conn.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
    }

    public void contributeToGraph(CompoundDirectedGraph graph, Map map) {
        GraphAnimation.recordInitialState(this.getConnectionFigure());
        Node source = (Node)map.get(this.getSource());
        Node target = (Node)map.get(this.getTarget());
        Edge e = null;
        if (target.data != null && target.data instanceof AbstractStatePart) {
            IState startState = ((IWebflowState)((AbstractStatePart)target.data).getState().getElementParent()).getStartState();
            IState sourceState = ((AbstractStatePart)source.data).getState();
            IState targetState = ((AbstractStatePart)target.data).getState();
            if (startState != null && startState.getId().equals(targetState.getId())) {
                e = new Edge((Object)this, target, source);
            } else {
                List children = ((IWebflowState)((AbstractStatePart)target.data).getState().getElementParent()).getStates();
                int sourceIndex = children.indexOf(sourceState);
                int targetIndex = children.indexOf(targetState);
                e = targetIndex < sourceIndex ? new Edge((Object)this, target, source) : new Edge((Object)this, source, target);
            }
        } else {
            List children = ((IWebflowState)((AbstractStatePart)target.data).getState().getElementParent()).getStates();
            int sourceIndex = children.indexOf(source);
            int targetIndex = children.indexOf(target);
            e = targetIndex < sourceIndex ? new Edge((Object)this, target, source) : new Edge((Object)this, source, target);
        }
        this.getTransitionModel().getActions().size();
        graph.edges.add((Object)e);
        map.put(this, e);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new TransitionEditPolicy());
    }

    protected IFigure createFigure() {
        PolylineConnection conn = (PolylineConnection)super.createFigure();
        if (this.getTransitionModel().getActions().size() > 0) {
            this.label = new Label();
            this.label.setBorder((Border)new LineBorder());
            this.label.setBackgroundColor(COLOR);
            this.label.setOpaque(true);
            this.label.setIcon(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.action_obj.gif"));
            conn.add((IFigure)this.label, (Object)new ConnectionLocator((Connection)conn));
        }
        conn.setToolTip((IFigure)new Label(this.eLabelProvider.getText(this.getModel(), false, true, true)));
        conn.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
        return conn;
    }

    public void deactivate() {
        super.deactivate();
        ((IWebflowModelElement)this.getModel()).removePropertyChangeListener((PropertyChangeListener)this);
    }

    public IStateTransition getTransitionModel() {
        return (IStateTransition)this.getModel();
    }

    public void performRequest(Request request) {
        IEditorPart editor;
        ActionRegistry actionRegistry;
        IAction action;
        if (request.getType().equals("open") && (action = (actionRegistry = (ActionRegistry)(editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()).getAdapter(ActionRegistry.class)).getAction((Object)"Edit_propeties")) != null && action.isEnabled()) {
            action.run();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("add_children".equals(prop) || "remove_children".equals(prop) || "move_children".equals(prop)) {
            this.refreshVisualsInternal();
        }
    }

    public void refreshVisualsInternal() {
        if (this.getTransitionModel().getActions().size() > 0) {
            if (this.label != null && this.getFigure().getChildren().contains(this.label)) {
                this.getFigure().remove((IFigure)this.label);
                this.label = null;
            }
            this.label = new Label();
            this.label.setBorder((Border)new LineBorder());
            this.label.setBackgroundColor(COLOR);
            this.label.setOpaque(true);
            this.label.setIcon(WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.action_obj.gif"));
            if (this.conn != null) {
                this.conn.add((IFigure)this.label, (Object)new ConnectionLocator((Connection)this.conn));
            }
        } else if (this.label != null && this.getFigure().getChildren().contains(this.label)) {
            this.getFigure().remove((IFigure)this.label);
            this.label = null;
        }
        this.getFigure().setToolTip((IFigure)new Label(this.eLabelProvider.getText(this.getModel(), false, true, true)));
        ((GraphicalEditPart)this.getViewer().getContents()).getFigure().revalidate();
    }

    public void setSelected(int value) {
        super.setSelected(value);
        if (value != 0) {
            ((PolylineConnection)this.getFigure()).setLineWidth(2);
            if (this.label != null) {
                ((LineBorder)this.label.getBorder()).setWidth(2);
            }
        } else {
            ((PolylineConnection)this.getFigure()).setLineWidth(1);
            if (this.label != null) {
                ((LineBorder)this.label.getBorder()).setWidth(1);
            }
        }
    }
}

