/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.parts;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Request;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IInlineFlowState;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.graph.figures.CompoundStateFigure;
import org.springframework.ide.eclipse.webflow.ui.graph.figures.InlineFlowStateFigure;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.AbstractStatePart;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.ChildrenStatePart;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.StateTransitionPart;

public class InlineFlowStatePart
extends ChildrenStatePart {
    public void activate() {
        super.activate();
        ((IInlineFlowState)this.getModel()).getWebFlowState().addPropertyChangeListener((PropertyChangeListener)this);
    }

    protected IFigure createFigure() {
        InlineFlowStateFigure figure = new InlineFlowStateFigure((IWebflowModelElement)this.getModel());
        ((Label)figure.getHeader()).setIcon(labelProvider.getImage(this.getModel()));
        ((Label)figure.getHeader()).setIconTextGap(5);
        ((Label)figure.getHeader()).setIconAlignment(8);
        return figure;
    }

    public void deactivate() {
        super.deactivate();
        ((IInlineFlowState)this.getModel()).getWebFlowState().removePropertyChangeListener((PropertyChangeListener)this);
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return null;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return null;
    }

    protected void applyChildrenResults(CompoundDirectedGraph graph, Map map) {
        CompoundStateFigure figure = (CompoundStateFigure)this.getFigure();
        int headerY = figure.getHeader().getBounds().getBottom().y + 7;
        int diff = -1;
        int i = 0;
        while (i < this.getChildren().size()) {
            AbstractStatePart part = (AbstractStatePart)this.getChildren().get(i);
            part.applyGraphResults(graph, map);
            Point p = part.getFigure().getBounds().getLocation();
            if (diff == -1) {
                diff = p.y - headerY;
            }
            p.y -= diff;
            part.getFigure().setLocation(p);
            ++i;
        }
    }

    public void contributeEdgesToGraph(CompoundDirectedGraph graph, Map map) {
        List outgoing = this.getSourceConnections();
        int i = 0;
        while (i < outgoing.size()) {
            StateTransitionPart part = (StateTransitionPart)this.getSourceConnections().get(i);
            part.contributeToGraph(graph, map);
            ++i;
        }
        i = 0;
        while (i < this.getChildren().size()) {
            AbstractStatePart child = (AbstractStatePart)this.children.get(i);
            if (child.getModel() instanceof IActionElement) {
                if (i + 1 < this.children.size()) {
                    Edge e = new Edge((Node)map.get(child), (Node)map.get(this.getChildren().get(i + 1)));
                    e.weight = 1;
                    graph.edges.add((Object)e);
                    map.put(String.valueOf(this.toString()) + i, e);
                }
            } else {
                child.contributeEdgesToGraph(graph, map);
            }
            ++i;
        }
    }

    protected List getModelChildren() {
        if (this.getModel() instanceof IInlineFlowState) {
            ArrayList states = new ArrayList();
            states.addAll(((IInlineFlowState)this.getModel()).getWebFlowState().getStates());
            states.addAll(((IInlineFlowState)this.getModel()).getWebFlowState().getInlineFlowStates());
            return states;
        }
        return Collections.EMPTY_LIST;
    }
}

