/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.parts;

import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IActionState;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeMapper;
import org.springframework.ide.eclipse.webflow.core.model.IExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.ISubflowState;
import org.springframework.ide.eclipse.webflow.core.model.IViewState;
import org.springframework.ide.eclipse.webflow.ui.graph.figures.CompoundStateFigure;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.AbstractStatePart;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.ChildrenStatePart;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.StateTransitionPart;

public class ActionStatePart
extends ChildrenStatePart {
    protected void applyChildrenResults(CompoundDirectedGraph graph, Map map) {
        CompoundStateFigure figure = (CompoundStateFigure)this.getFigure();
        int headerY = figure.getHeader().getBounds().getBottom().y + 8;
        int i = 0;
        while (i < this.getChildren().size()) {
            AbstractStatePart part = (AbstractStatePart)this.getChildren().get(i);
            part.applyGraphResults(graph, map);
            Point p = part.getFigure().getBounds().getLocation();
            p.y = headerY + i * 23;
            part.getFigure().setLocation(p);
            ++i;
        }
        this.applyMaxWidths();
    }

    public void contributeEdgesToGraph(CompoundDirectedGraph graph, Map map) {
        List outgoing = this.getSourceConnections();
        int i = 0;
        while (i < outgoing.size()) {
            StateTransitionPart part = (StateTransitionPart)this.getSourceConnections().get(i);
            part.contributeToGraph(graph, map);
            ++i;
        }
        i = 0;
        while (i < this.getChildren().size()) {
            AbstractStatePart child = (AbstractStatePart)this.children.get(i);
            if (child.getModel() instanceof IActionElement || child.getModel() instanceof IExceptionHandler || child.getModel() instanceof IAttributeMapper) {
                if (i + 1 < this.children.size()) {
                    Edge e = new Edge((Node)map.get(child), (Node)map.get(this.getChildren().get(i + 1)));
                    e.weight = 1;
                    graph.edges.add((Object)e);
                    map.put(String.valueOf(this.toString()) + i, e);
                }
            } else {
                child.contributeEdgesToGraph(graph, map);
            }
            ++i;
        }
    }

    protected void onGetModelChildren(List children) {
        IState state = (IState)this.getModel();
        if (state instanceof IActionState) {
            if (((IActionState)state).getActions() != null) {
                children.addAll(((IActionState)state).getActions());
            }
        } else if (state instanceof IViewState) {
            if (((IViewState)state).getRenderActions() != null) {
                children.addAll(((IViewState)state).getRenderActions().getRenderActions());
            }
        } else if (state instanceof ISubflowState && ((ISubflowState)state).getAttributeMapper() != null) {
            children.add(((ISubflowState)state).getAttributeMapper());
        }
    }
}

