/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.graph.figures.ShadowedLineBorder;
import org.springframework.ide.eclipse.webflow.ui.graph.figures.SubgraphFigure;
import org.springframework.ide.eclipse.webflow.ui.graph.preferences.WebflowGraphPreferences;

public class CompoundStateFigure
extends SubgraphFigure {
    private boolean selected;
    private IWebflowModelElement model;

    public CompoundStateFigure(IWebflowModelElement model) {
        super((IFigure)new Label(""), (IFigure)new Label(""));
        this.setBorder((Border)new ShadowedLineBorder());
        this.setOpaque(true);
        this.model = model;
    }

    protected void paintFigure(Graphics g) {
        super.paintFigure(g);
        Rectangle r = super.getBounds();
        g.setAntialias(1);
        g.setBackgroundColor(WebflowGraphPreferences.getColorForModelElement(this.model));
        if (this.selected) {
            g.setBackgroundColor(ColorConstants.menuBackgroundSelected);
            g.setForegroundColor(ColorConstants.menuForegroundSelected);
        }
        g.fillRectangle(r.x, r.y, 5, r.height - 5);
        g.fillRectangle(r.right() - 9, r.y, 5, r.height - 5);
        g.fillRectangle(r.x, r.bottom() - 9, r.width - 5, 5);
        if (this.getHeader().getPreferredSize().height < 20) {
            g.fillRectangle(r.x, r.y, r.width - 5, 20);
        } else {
            g.fillRectangle(r.x, r.y, r.width - 5, 29);
        }
    }

    public void setSelected(boolean selected) {
        if (this.selected == selected) {
            return;
        }
        this.selected = selected;
        if (!selected) {
            this.getHeader().setForegroundColor(null);
            this.getFooter().setForegroundColor(null);
        } else {
            this.getHeader().setForegroundColor(ColorConstants.menuForegroundSelected);
            this.getFooter().setForegroundColor(ColorConstants.menuForegroundSelected);
        }
        this.repaint();
    }
}

