/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.DecoratedField;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IControlCreator;
import org.eclipse.jface.fieldassist.TextControlCreator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.webflow.core.internal.model.Argument;
import org.springframework.ide.eclipse.webflow.core.internal.model.BeanAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.MethodArguments;
import org.springframework.ide.eclipse.webflow.core.internal.model.MethodResult;
import org.springframework.ide.eclipse.webflow.core.model.IArgument;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeEnabled;
import org.springframework.ide.eclipse.webflow.core.model.IMethodArguments;
import org.springframework.ide.eclipse.webflow.core.model.IMethodResult;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;
import org.springframework.ide.eclipse.webflow.ui.graph.WebflowUtils;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.DialogUtils;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.IDialogValidator;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.MethodArgumentContentProvider;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.MethodArgumentEditorDialog;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.ModelTableLabelProvider;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.PropertiesComposite;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.TableCellModifier;

public class BeanActionPropertiesDialog
extends TitleAreaDialog
implements IDialogValidator {
    private BeanAction action;
    private BeanAction actionClone;
    private Label nameLabel;
    private Text nameText;
    private Label beanLabel;
    private Text beanText;
    private Label methodLabel;
    private Text methodText;
    private Button okButton;
    private int LABEL_WIDTH = 70;
    private IDialogValidator validator;
    private PropertiesComposite properties;
    private Button browseBeanButton;
    private Button browseMethodButton;
    private TableViewer configsViewer;
    private Button removeButton;
    private Button addButton;
    private Button editButton;
    private List<IArgument> methodArguments;
    private SelectionListener buttonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            BeanActionPropertiesDialog.this.handleButtonPressed((Button)e.widget);
        }
    };
    private Combo scopeText;
    private Label scopeLabel;
    private Label resultNameLabel;
    private Text resultNameText;

    public BeanActionPropertiesDialog(Shell parentShell, IWebflowModelElement parent, BeanAction state) {
        super(parentShell);
        this.action = state;
        this.actionClone = this.action.cloneModelElement();
        if (this.actionClone.getMethodArguments() != null) {
            this.methodArguments = new ArrayList<IArgument>();
            this.methodArguments.addAll(this.actionClone.getMethodArguments().getArguments());
        } else {
            this.methodArguments = new ArrayList<IArgument>();
            MethodArguments entry = new MethodArguments();
            entry.createNew((IWebflowModelElement)this.actionClone);
            this.actionClone.setMethodArguments((IMethodArguments)entry);
        }
    }

    private String trimString(String string) {
        if (string != null && string == "") {
            string = null;
        }
        return string;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.actionClone.setName(this.trimString(this.nameText.getText()));
            this.actionClone.setMethod(this.trimString(this.methodText.getText()));
            this.actionClone.setBean(this.trimString(this.beanText.getText()));
            if (this.action.getMethodArguments() == null && this.methodArguments.size() > 0) {
                MethodArguments entry = new MethodArguments();
                entry.createNew((IWebflowModelElement)this.actionClone);
                for (IArgument a : this.methodArguments) {
                    entry.addArgument(a);
                }
                this.actionClone.setMethodArguments((IMethodArguments)entry);
            } else if (this.methodArguments.size() == 0) {
                this.actionClone.setMethodArguments(null);
            } else {
                this.actionClone.getMethodArguments().removeAll();
                for (IArgument a : this.methodArguments) {
                    this.actionClone.getMethodArguments().addArgument(a);
                }
            }
            if (this.trimString(this.scopeText.getText()) == null && this.trimString(this.resultNameText.getText()) == null) {
                this.actionClone.setMethodResult(null);
            } else if (this.action.getMethodResult() != null) {
                this.actionClone.getMethodResult().setName(this.resultNameText.getText());
                this.actionClone.getMethodResult().setScope(this.scopeText.getText());
            } else if (this.action.getMethodResult() == null) {
                MethodResult result = new MethodResult();
                result.createNew((IWebflowModelElement)this.actionClone);
                this.actionClone.setMethodResult((IMethodResult)result);
                this.actionClone.getMethodResult().setName(this.resultNameText.getText());
                this.actionClone.getMethodResult().setScope(this.scopeText.getText());
            }
            this.action.applyCloneValues(this.actionClone);
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getShellTitle());
        shell.setImage(this.getImage());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.nameText.setFocus();
        if (this.action != null && this.action.getName() != null) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
        this.validateInput();
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.getTitle());
        this.setMessage(this.getMessage());
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        TabFolder folder = new TabFolder(composite, 0);
        folder.setLayoutData((Object)new GridData(1808));
        TabItem item1 = new TabItem(folder, 0);
        item1.setText("General");
        item1.setImage(this.getImage());
        TabItem item2 = new TabItem(folder, 0);
        Group groupActionType = new Group((Composite)folder, 0);
        GridLayout layoutAttMap = new GridLayout();
        layoutAttMap.marginWidth = 3;
        layoutAttMap.marginHeight = 3;
        groupActionType.setLayout((Layout)layoutAttMap);
        groupActionType.setText(" Action ");
        GridData grid = new GridData();
        groupActionType.setLayoutData((Object)grid);
        Composite nameGroup = new Composite((Composite)groupActionType, 0);
        nameGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout1 = new GridLayout();
        layout1.numColumns = 3;
        layout1.marginWidth = 5;
        nameGroup.setLayout((Layout)layout1);
        this.nameLabel = new Label(nameGroup, 0);
        this.nameLabel.setText("Name");
        this.nameText = new Text(nameGroup, 2052);
        if (this.action != null && this.action.getName() != null) {
            this.nameText.setText(this.action.getName());
        }
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BeanActionPropertiesDialog.this.validateInput();
            }
        });
        new Label(nameGroup, 0);
        this.beanLabel = new Label(nameGroup, 0);
        this.beanLabel.setText("Bean");
        GridData gridData = new GridData(32);
        gridData.widthHint = this.LABEL_WIDTH;
        this.beanLabel.setLayoutData((Object)gridData);
        DecoratedField beanField = new DecoratedField(nameGroup, 2052, (IControlCreator)new TextControlCreator());
        FieldDecoration requiredFieldIndicator = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        beanField.addFieldDecoration(requiredFieldIndicator, 16512, true);
        this.beanText = (Text)beanField.getControl();
        GridData data = new GridData(256);
        beanField.getLayoutControl().setLayoutData((Object)data);
        if (this.action != null && this.action.getBean() != null) {
            this.beanText.setText(this.action.getBean());
        }
        this.beanText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (BeanActionPropertiesDialog.this.validator != null) {
                    BeanActionPropertiesDialog.this.validator.validateInput();
                }
            }
        });
        DialogUtils.attachContentAssist(this.beanText, WebflowUtils.getBeansFromEditorInput().toArray());
        this.browseBeanButton = new Button(nameGroup, 8);
        this.browseBeanButton.setText("...");
        this.browseBeanButton.setLayoutData((Object)new GridData(128));
        this.browseBeanButton.addSelectionListener(this.buttonListener);
        this.methodLabel = new Label(nameGroup, 0);
        this.methodLabel.setText("Method");
        DecoratedField methodField = new DecoratedField(nameGroup, 2052, (IControlCreator)new TextControlCreator());
        FieldDecoration requiredFieldIndicator1 = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        methodField.addFieldDecoration(requiredFieldIndicator1, 16512, true);
        this.methodText = (Text)methodField.getControl();
        data = new GridData(256);
        methodField.getLayoutControl().setLayoutData((Object)data);
        if (this.action != null && this.action.getMethod() != null) {
            this.methodText.setText(this.action.getMethod());
        }
        this.methodText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BeanActionPropertiesDialog.this.validateInput();
            }
        });
        DialogUtils.attachContentAssist(this.methodText, WebflowUtils.getActionMethods(this.actionClone.getNode()).toArray());
        this.browseMethodButton = new Button(nameGroup, 8);
        this.browseMethodButton.setText("...");
        this.browseMethodButton.setLayoutData((Object)new GridData(128));
        this.browseMethodButton.addSelectionListener(this.buttonListener);
        data = new GridData(768);
        data.horizontalIndent = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
        this.nameText.setLayoutData((Object)data);
        Group groupPropertyType = new Group((Composite)groupActionType, 0);
        GridLayout layoutPropMap = new GridLayout();
        layoutPropMap.marginWidth = 3;
        layoutPropMap.marginHeight = 3;
        groupPropertyType.setLayout((Layout)layoutPropMap);
        groupPropertyType.setText(" Method Arguments ");
        groupPropertyType.setLayoutData((Object)new GridData(768));
        Composite tableAndButtons = new Composite((Composite)groupPropertyType, 0);
        tableAndButtons.setLayoutData((Object)new GridData(768));
        GridLayout layout2 = new GridLayout();
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        layout2.numColumns = 2;
        tableAndButtons.setLayout((Layout)layout2);
        Table configsTable = new Table(tableAndButtons, 68354);
        data = new GridData(1808);
        data.heightHint = 70;
        configsTable.setLayoutData((Object)data);
        TableColumn columnName = new TableColumn(configsTable, 0);
        columnName.setText("Expression");
        columnName.setWidth(150);
        TableColumn columnType = new TableColumn(configsTable, 0);
        columnType.setText("Type");
        columnType.setWidth(200);
        configsTable.setHeaderVisible(true);
        this.configsViewer = new TableViewer(configsTable);
        String[] columnNames = new String[]{"Expression", "Type"};
        this.configsViewer.setColumnProperties(columnNames);
        this.configsViewer.setContentProvider((IContentProvider)new MethodArgumentContentProvider(this.methodArguments, this.configsViewer));
        this.configsViewer.setLabelProvider((IBaseLabelProvider)new ModelTableLabelProvider());
        this.configsViewer.setCellModifier((ICellModifier)new TableCellModifier());
        this.configsViewer.setInput((Object)this.action);
        configsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BeanActionPropertiesDialog.this.handleTableSelectionChanged();
            }
        });
        Composite buttonArea = new Composite(tableAndButtons, 0);
        GridLayout layout4 = new GridLayout();
        layout4.marginHeight = 0;
        layout4.marginWidth = 0;
        buttonArea.setLayout((Layout)layout4);
        buttonArea.setLayoutData((Object)new GridData(1040));
        this.addButton = new Button(buttonArea, 8);
        this.addButton.setText("Add");
        GridData data1 = new GridData(256);
        data1.widthHint = 40;
        this.addButton.setLayoutData((Object)data1);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Argument property = new Argument();
                property.createNew((IWebflowModelElement)BeanActionPropertiesDialog.this.actionClone);
                MethodArgumentEditorDialog dialog = new MethodArgumentEditorDialog(BeanActionPropertiesDialog.this.getParentShell(), (IArgument)property);
                if (dialog.open() == 0) {
                    BeanActionPropertiesDialog.this.methodArguments.add(property);
                    BeanActionPropertiesDialog.this.configsViewer.refresh(true);
                }
            }
        });
        this.editButton = new Button(buttonArea, 8);
        this.editButton.setText("Edit");
        data1 = new GridData(256);
        data1.widthHint = 40;
        this.editButton.setLayoutData((Object)data1);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)BeanActionPropertiesDialog.this.configsViewer.getSelection();
                if (selection.getFirstElement() != null && selection.getFirstElement() instanceof IArgument) {
                    IArgument property = (IArgument)selection.getFirstElement();
                    MethodArgumentEditorDialog dialog = new MethodArgumentEditorDialog(BeanActionPropertiesDialog.this.getParentShell(), property);
                    if (dialog.open() == 0) {
                        BeanActionPropertiesDialog.this.configsViewer.refresh(true);
                    }
                }
            }
        });
        this.removeButton = new Button(buttonArea, 8);
        this.removeButton.setText("Delete");
        GridData data2 = new GridData(256);
        data1.widthHint = 40;
        this.removeButton.setLayoutData((Object)data2);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)BeanActionPropertiesDialog.this.configsViewer.getSelection();
                if (selection.getFirstElement() != null && selection.getFirstElement() instanceof IArgument) {
                    IArgument property = (IArgument)selection.getFirstElement();
                    BeanActionPropertiesDialog.this.methodArguments.remove(property);
                    BeanActionPropertiesDialog.this.configsViewer.refresh(true);
                }
            }
        });
        this.removeButton.setEnabled(false);
        this.editButton.setEnabled(false);
        Group groupMethodResult = new Group((Composite)groupActionType, 0);
        layoutAttMap = new GridLayout();
        layoutAttMap.marginWidth = 3;
        layoutAttMap.marginHeight = 3;
        layoutAttMap.numColumns = 3;
        layoutAttMap.marginWidth = 5;
        groupMethodResult.setLayout((Layout)layoutAttMap);
        groupMethodResult.setText(" Method Result ");
        groupMethodResult.setLayoutData((Object)new GridData(768));
        this.resultNameLabel = new Label((Composite)groupMethodResult, 0);
        this.resultNameLabel.setText("Name");
        this.resultNameText = new Text((Composite)groupMethodResult, 2052);
        if (this.action != null && this.action.getMethodResult() != null) {
            this.resultNameText.setText(this.action.getMethodResult().getName());
        }
        this.resultNameText.setLayoutData((Object)new GridData(768));
        this.resultNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BeanActionPropertiesDialog.this.validateInput();
            }
        });
        new Label((Composite)groupMethodResult, 0);
        this.scopeLabel = new Label((Composite)groupMethodResult, 0);
        this.scopeLabel.setText("Scope");
        gridData = new GridData(32);
        gridData.widthHint = this.LABEL_WIDTH;
        this.scopeLabel.setLayoutData((Object)gridData);
        this.scopeText = new Combo((Composite)groupMethodResult, 2060);
        this.scopeText.setItems(new String[]{"", "request", "flash", "flow", "conversation", "default"});
        if (this.action != null && this.action.getMethodResult() != null && this.action.getMethodResult().getScope() != null) {
            this.scopeText.setText(this.action.getMethodResult().getScope());
        }
        this.scopeText.setLayoutData((Object)new GridData(768));
        this.scopeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BeanActionPropertiesDialog.this.validator.validateInput();
            }
        });
        new Label((Composite)groupMethodResult, 0);
        item1.setControl((Control)groupActionType);
        this.properties = new PropertiesComposite(this, item2, this.getShell(), (IAttributeEnabled)this.actionClone);
        item2.setControl(this.properties.createDialogArea((Composite)folder));
        BeanActionPropertiesDialog.applyDialogFont((Control)parentComposite);
        return parentComposite;
    }

    protected Image getImage() {
        return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.bean_action_obj.gif");
    }

    public String getMessage() {
        return "Enter the details for the Bean action";
    }

    public String getName() {
        return this.nameText.getText();
    }

    protected String getShellTitle() {
        return "Bean Action";
    }

    protected String getTitle() {
        return "Bean Action properties";
    }

    protected void showError(String error) {
        super.setErrorMessage(error);
    }

    public void validateInput() {
        boolean error = false;
        StringBuffer errorMessage = new StringBuffer();
        if (error) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(errorMessage.toString());
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
        }
    }

    private void handleButtonPressed(Button button) {
        ElementListSelectionDialog dialog;
        if (button.equals(this.browseBeanButton)) {
            ElementListSelectionDialog dialog2 = DialogUtils.openBeanReferenceDialog(this.beanText.getText(), false);
            if (dialog2.open() == 0) {
                this.beanText.setText(((IBean)dialog2.getFirstResult()).getElementName());
            }
        } else if (button.equals(this.browseMethodButton) && (dialog = DialogUtils.openActionMethodReferenceDialog(this.actionClone.getNode())).open() == 0) {
            this.methodText.setText(((IMethod)dialog.getFirstResult()).getElementName());
        }
    }

    private void handleTableSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.configsViewer.getSelection();
        if (selection.isEmpty()) {
            this.removeButton.setEnabled(false);
            this.editButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
            this.editButton.setEnabled(true);
        }
    }
}

