/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.springframework.ide.eclipse.webflow.core.internal.model.EntryActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.ExitActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IActionState;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeEnabled;
import org.springframework.ide.eclipse.webflow.core.model.ICloneableModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IEntryActions;
import org.springframework.ide.eclipse.webflow.core.model.IExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.model.IExitActions;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.ActionComposite;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.ExceptionHandlerComposite;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.IDialogValidator;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.PropertiesComposite;

public class ActionStatePropertiesDialog
extends TitleAreaDialog
implements IDialogValidator {
    private IActionState actionState;
    private IActionState actionStateClone;
    private Label nameLabel;
    private Text nameText;
    private Button okButton;
    private IWebflowModelElement parent;
    private PropertiesComposite properties;
    private ActionComposite actionsComposite;
    private ActionComposite entryActionsComposite;
    private ActionComposite exitActionsComposite;
    private ExceptionHandlerComposite exceptionHandlerComposite;
    private List<IActionElement> entryActions;
    private List<IActionElement> exitActions;
    private List<IActionElement> actions;
    private List<IExceptionHandler> exceptionHandler;
    private Text parentText;
    private Label parentLabel;

    public ActionStatePropertiesDialog(Shell parentShell, IWebflowModelElement parent, IActionState state) {
        super(parentShell);
        this.actionState = state;
        this.parent = parent;
        this.actionStateClone = (IActionState)((ICloneableModelElement)state).cloneModelElement();
        if (this.actionStateClone.getEntryActions() != null) {
            this.entryActions = new ArrayList<IActionElement>();
            this.entryActions.addAll(this.actionStateClone.getEntryActions().getEntryActions());
        } else {
            this.entryActions = new ArrayList<IActionElement>();
            EntryActions entry = new EntryActions();
            entry.createNew((IWebflowModelElement)this.actionStateClone);
            this.actionStateClone.setEntryActions((IEntryActions)entry);
        }
        if (this.actionStateClone.getExitActions() != null) {
            this.exitActions = new ArrayList<IActionElement>();
            this.exitActions.addAll(this.actionStateClone.getExitActions().getExitActions());
        } else {
            this.exitActions = new ArrayList<IActionElement>();
            ExitActions exit = new ExitActions();
            exit.createNew((IWebflowModelElement)this.actionStateClone);
            this.actionStateClone.setExitActions((IExitActions)exit);
        }
        this.actions = new ArrayList<IActionElement>();
        if (this.actionStateClone.getActions() != null) {
            this.actions.addAll(this.actionStateClone.getActions());
        }
        this.exceptionHandler = new ArrayList<IExceptionHandler>();
        if (this.actionStateClone.getExceptionHandlers() != null) {
            this.exceptionHandler.addAll(this.actionStateClone.getExceptionHandlers());
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.actionStateClone.setId(this.trimString(this.getId()));
            if (!WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.actionState)) {
                this.actionStateClone.setParent(this.trimString(this.getParent()));
            }
            if (this.actionState.getEntryActions() == null && this.entryActions.size() > 0) {
                EntryActions entryActions = new EntryActions();
                entryActions.createNew((IWebflowModelElement)this.actionStateClone);
                for (IActionElement a : this.entryActions) {
                    entryActions.addEntryAction(a);
                }
                this.actionStateClone.setEntryActions((IEntryActions)entryActions);
            } else if (this.entryActions.size() == 0) {
                this.actionStateClone.setEntryActions(null);
            } else {
                this.actionStateClone.getEntryActions().removeAll();
                for (IActionElement iActionElement : this.entryActions) {
                    this.actionStateClone.getEntryActions().addEntryAction(iActionElement);
                }
            }
            if (this.actionState.getExitActions() == null && this.exitActions.size() > 0) {
                ExitActions exitActions = new ExitActions();
                exitActions.createNew((IWebflowModelElement)this.actionStateClone);
                for (IActionElement a : this.exitActions) {
                    exitActions.addExitAction(a);
                }
                this.actionStateClone.setExitActions((IExitActions)exitActions);
            } else if (this.exitActions.size() == 0) {
                this.actionStateClone.setExitActions(null);
            } else {
                this.actionStateClone.getExitActions().removeAll();
                for (IActionElement iActionElement : this.exitActions) {
                    this.actionStateClone.getExitActions().addExitAction(iActionElement);
                }
            }
            if (this.actions != null && this.actions.size() > 0) {
                this.actionStateClone.removeAll();
                for (IActionElement iActionElement : this.actions) {
                    this.actionStateClone.addAction(iActionElement);
                }
            } else {
                this.actionStateClone.removeAll();
            }
            if (this.exceptionHandler != null && this.exceptionHandler.size() > 0) {
                this.actionStateClone.removeAllExceptionHandler();
                for (IExceptionHandler iExceptionHandler : this.exceptionHandler) {
                    this.actionStateClone.addExceptionHandler(iExceptionHandler);
                }
            } else {
                this.actionStateClone.removeAllExceptionHandler();
            }
            ((ICloneableModelElement)this.actionState).applyCloneValues((IWebflowModelElement)this.actionStateClone);
        }
        super.buttonPressed(buttonId);
    }

    private String getParent() {
        return this.parentText.getText();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getShellTitle());
        shell.setImage(this.getImage());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.nameText.setFocus();
        if (this.actionState != null && this.actionState.getId() != null) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.getTitle());
        this.setMessage(this.getMessage());
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        TabFolder folder = new TabFolder(composite, 0);
        TabItem item1 = new TabItem(folder, 0);
        item1.setText("General");
        item1.setImage(this.getImage());
        TabItem item2 = new TabItem(folder, 0);
        TabItem item3 = new TabItem(folder, 0);
        TabItem item4 = new TabItem(folder, 0);
        TabItem item5 = new TabItem(folder, 0);
        TabItem item6 = new TabItem(folder, 0);
        Group groupActionType = new Group((Composite)folder, 0);
        GridLayout layoutAttMap = new GridLayout();
        layoutAttMap.marginWidth = 3;
        layoutAttMap.marginHeight = 3;
        groupActionType.setLayout((Layout)layoutAttMap);
        groupActionType.setText(" Action State ");
        GridData grid = new GridData();
        groupActionType.setLayoutData((Object)grid);
        Composite nameGroup = new Composite((Composite)groupActionType, 0);
        nameGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout1 = new GridLayout();
        layout1.numColumns = 2;
        layout1.marginWidth = 5;
        nameGroup.setLayout((Layout)layout1);
        this.nameLabel = new Label(nameGroup, 0);
        this.nameLabel.setText("State id");
        this.nameText = new Text(nameGroup, 2052);
        if (this.actionState != null && this.actionState.getId() != null) {
            this.nameText.setText(this.actionState.getId());
        }
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ActionStatePropertiesDialog.this.validateInput();
            }
        });
        if (!WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.actionState)) {
            this.parentLabel = new Label(nameGroup, 0);
            this.parentLabel.setText("Parent state id");
            this.parentText = new Text(nameGroup, 2052);
            if (this.actionState != null && this.actionState.getParent() != null) {
                this.parentText.setText(this.actionState.getParent());
            }
            this.parentText.setLayoutData((Object)new GridData(768));
            this.parentText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ActionStatePropertiesDialog.this.validateInput();
                }
            });
        }
        item1.setControl((Control)groupActionType);
        this.actionsComposite = new ActionComposite(this, item2, this.getShell(), this.actions, (IWebflowModelElement)this.actionStateClone, IActionElement.ACTION_TYPE.ACTION);
        item2.setControl(this.actionsComposite.createDialogArea((Composite)folder));
        this.entryActionsComposite = new ActionComposite(this, item3, this.getShell(), this.entryActions, (IWebflowModelElement)this.actionStateClone.getEntryActions(), IActionElement.ACTION_TYPE.ENTRY_ACTION);
        item3.setControl(this.entryActionsComposite.createDialogArea((Composite)folder));
        this.exitActionsComposite = new ActionComposite(this, item4, this.getShell(), this.exitActions, (IWebflowModelElement)this.actionStateClone.getExitActions(), IActionElement.ACTION_TYPE.EXIT_ACTION);
        item4.setControl(this.exitActionsComposite.createDialogArea((Composite)folder));
        this.exceptionHandlerComposite = new ExceptionHandlerComposite(this, item5, this.getShell(), this.exceptionHandler, (IWebflowModelElement)this.actionStateClone);
        item5.setControl(this.exceptionHandlerComposite.createDialogArea((Composite)folder));
        this.properties = new PropertiesComposite(this, item6, this.getShell(), (IAttributeEnabled)this.actionStateClone);
        item6.setControl(this.properties.createDialogArea((Composite)folder));
        ActionStatePropertiesDialog.applyDialogFont((Control)parentComposite);
        return parentComposite;
    }

    public String getId() {
        return this.nameText.getText();
    }

    protected Image getImage() {
        return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.action_state_obj.gif");
    }

    public String getMessage() {
        return "Enter the details for the action state";
    }

    public IWebflowModelElement getModelElementParent() {
        return this.parent;
    }

    protected String getShellTitle() {
        return "Action State";
    }

    protected String getTitle() {
        return "Action State properties";
    }

    protected void showError(String error) {
        super.setErrorMessage(error);
    }

    public String trimString(String string) {
        if (string != null && string == "") {
            string = null;
        }
        return string;
    }

    public void validateInput() {
        String id = this.nameText.getText();
        boolean error = false;
        StringBuffer errorMessage = new StringBuffer();
        if (id == null || "".equals(id)) {
            errorMessage.append("A valid id attribute is required. ");
            error = true;
        }
        if (error) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(errorMessage.toString());
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
        }
    }
}

