/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.commands;

import org.eclipse.gef.commands.Command;
import org.springframework.ide.eclipse.webflow.core.model.IIf;
import org.springframework.ide.eclipse.webflow.core.model.IIfTransition;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.IStateTransition;
import org.springframework.ide.eclipse.webflow.core.model.ITransition;
import org.springframework.ide.eclipse.webflow.core.model.ITransitionableFrom;
import org.springframework.ide.eclipse.webflow.core.model.ITransitionableTo;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;

public class SplitIfTransitionCommand
extends Command {
    private IState newActivity;
    private IIfTransition newIncomingTransition;
    private IStateTransition newOutgoingTransition;
    private IIf oldSource;
    private ITransitionableTo oldTarget;
    private IWebflowState parent;
    private IIfTransition transition;

    public void execute() {
    }

    public void redo() {
        if (!this.transition.isThen()) {
            this.oldSource.setElseTransition(this.newIncomingTransition);
        } else {
            this.oldSource.setThenTransition(this.newIncomingTransition);
        }
        this.oldTarget.addInputTransition((ITransition)this.newOutgoingTransition);
        if (this.newActivity instanceof ITransitionableTo) {
            ((ITransitionableTo)this.newActivity).addInputTransition((ITransition)this.newIncomingTransition);
        }
        if (this.newActivity instanceof ITransitionableFrom) {
            ((ITransitionableFrom)this.newActivity).addOutputTransition((ITransition)this.newOutgoingTransition);
        }
        this.parent.addState(this.newActivity);
        this.oldTarget.removeInputTransition((ITransition)this.transition);
    }

    public void setNewActivity(IState activity) {
        this.newActivity = activity;
    }

    public void setParent(IWebflowState activity) {
        this.parent = activity;
    }

    public void setTransition(IIfTransition transition) {
        this.transition = transition;
        this.oldSource = transition.getFromIf();
        this.oldTarget = transition.getToState();
    }

    public void undo() {
        this.oldTarget.removeInputTransition((ITransition)this.newOutgoingTransition);
        if (this.newActivity instanceof ITransitionableTo) {
            ((ITransitionableTo)this.newActivity).removeInputTransition((ITransition)this.newIncomingTransition);
        }
        if (this.newActivity instanceof ITransitionableFrom) {
            ((ITransitionableFrom)this.newActivity).removeOutputTransition((ITransition)this.newOutgoingTransition);
        }
        this.parent.removeState(this.newActivity);
        if (!this.transition.isThen()) {
            this.oldSource.setElseTransition(this.transition);
        } else {
            this.oldSource.setThenTransition(this.transition);
        }
        this.oldTarget.addInputTransition((ITransition)this.transition);
    }
}

