/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.commands;

import org.eclipse.gef.commands.Command;
import org.springframework.ide.eclipse.webflow.core.model.IStateTransition;
import org.springframework.ide.eclipse.webflow.core.model.ITransition;
import org.springframework.ide.eclipse.webflow.core.model.ITransitionableFrom;
import org.springframework.ide.eclipse.webflow.core.model.ITransitionableTo;

public class ReconnectSourceCommand
extends Command {
    protected ITransitionableFrom oldSource;
    protected ITransitionableFrom source;
    protected ITransitionableTo target;
    protected IStateTransition transition;

    public boolean canExecute() {
        return !this.transition.getToState().equals(this.source);
    }

    public void execute() {
        if (this.source != null) {
            this.oldSource.removeOutputTransition((ITransition)this.transition);
            this.transition.setFromState(this.source);
            this.source.addOutputTransition((ITransition)this.transition);
        }
    }

    public ITransitionableFrom getSource() {
        return this.source;
    }

    public ITransitionableTo getTarget() {
        return this.target;
    }

    public ITransition getTransition() {
        return this.transition;
    }

    public void setSource(ITransitionableFrom activity) {
        this.source = activity;
    }

    public void setTarget(ITransitionableTo activity) {
        this.target = activity;
    }

    public void setTransition(IStateTransition trans) {
        this.transition = trans;
        this.target = trans.getToState();
        this.oldSource = trans.getFromState();
    }

    public void undo() {
        this.source.removeOutputTransition((ITransition)this.transition);
        this.transition.setFromState(this.oldSource);
        this.oldSource.addOutputTransition((ITransition)this.transition);
    }
}

