/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.commands;

import org.eclipse.gef.commands.Command;
import org.springframework.ide.eclipse.webflow.core.model.ICloneableModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IStateTransition;
import org.springframework.ide.eclipse.webflow.core.model.ITransitionableTo;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditPropertiesCommand
extends Command {
    private IWebflowModelElement child = null;
    private ITransitionableTo newTarget = null;
    private ICloneableModelElement<IWebflowModelElement> oldChild = null;
    private ITransitionableTo oldTarget = null;
    private boolean onlyReconnect = false;
    private IWebflowModelElement undoChild = null;

    public EditPropertiesCommand() {
        super("Properties");
    }

    public void execute() {
        if (!this.onlyReconnect) {
            IWebflowModelElement tempChild = ((ICloneableModelElement)this.child).cloneModelElement();
            this.oldChild.applyCloneValues(tempChild);
        }
        if (this.oldChild instanceof IStateTransition && this.newTarget != null) {
            this.oldTarget = ((IStateTransition)this.oldChild).getToState();
            ((IStateTransition)this.oldChild).setToState(this.newTarget);
        }
    }

    public IWebflowModelElement getChild() {
        return this.child;
    }

    public IWebflowModelElement getChildClone() {
        return this.child;
    }

    public void redo() {
        this.execute();
    }

    public void setChild(ICloneableModelElement<IWebflowModelElement> oldChild) {
        this.oldChild = oldChild;
        this.child = oldChild.cloneModelElement();
        this.undoChild = oldChild.cloneModelElement();
    }

    public void setChild(ICloneableModelElement<IWebflowModelElement> oldChild, IWebflowModelElement newChild) {
        this.oldChild = oldChild;
        this.child = newChild;
        this.undoChild = oldChild.cloneModelElement();
    }

    public void setNewTarget(ITransitionableTo newTarget) {
        this.newTarget = newTarget;
    }

    public void setOnlyReconnect(boolean onlyReconnect) {
        this.onlyReconnect = onlyReconnect;
    }

    public void undo() {
        if (!this.onlyReconnect) {
            IWebflowModelElement tempChild = ((ICloneableModelElement)this.undoChild).cloneModelElement();
            this.oldChild.applyCloneValues(tempChild);
        }
        if (this.oldChild instanceof IStateTransition && this.newTarget != null && this.oldTarget != null) {
            ((IStateTransition)this.oldChild).setToState(this.oldTarget);
        }
    }
}

