/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.ui.model;

import com.atlassian.connector.eclipse.internal.bamboo.ui.model.ITestElement;
import com.atlassian.connector.eclipse.internal.bamboo.ui.model.TestRoot;
import com.atlassian.connector.eclipse.internal.bamboo.ui.model.TestSuiteElement;
import org.eclipse.core.runtime.Assert;

public abstract class TestElement
implements ITestElement {
    private final TestSuiteElement fParent;
    private String fTestName;
    private Status fStatus;
    private String fTrace;
    private String fExpected;
    private String fActual;
    double fTime = Double.NaN;

    public TestElement(TestSuiteElement parent, String testName) {
        Assert.isNotNull((Object)testName);
        this.fParent = parent;
        this.fTestName = testName;
        this.fStatus = Status.OK;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public ITestElement.Result getTestResult(boolean includeChildren) {
        return this.getStatus().convertToResult();
    }

    public ITestElement.FailureTrace getFailureTrace() {
        ITestElement.Result testResult = this.getTestResult(false);
        if (testResult == ITestElement.Result.ERROR || testResult == ITestElement.Result.FAILURE) {
            return new ITestElement.FailureTrace(this.fTrace, this.fExpected, this.fActual);
        }
        return null;
    }

    public TestSuiteElement getParent() {
        return this.fParent;
    }

    public String getTestName() {
        return this.fTestName;
    }

    public void setName(String name) {
        this.fTestName = name;
    }

    public void setStatus(Status status) {
        this.fStatus = status;
        TestSuiteElement parent = this.getParent();
        if (parent != null) {
            parent.childChangedStatus(this, status);
        }
    }

    public void setStatus(Status status, String trace, String expected, String actual) {
        if (trace != null && this.fTrace != null) {
            this.fTrace = String.valueOf(this.fTrace) + trace;
        } else {
            this.fTrace = trace;
            this.fExpected = expected;
            this.fActual = actual;
        }
        this.setStatus(status);
    }

    public Status getStatus() {
        return this.fStatus;
    }

    public String getTrace() {
        return this.fTrace;
    }

    public String getExpected() {
        return this.fExpected;
    }

    public String getActual() {
        return this.fActual;
    }

    public boolean isComparisonFailure() {
        return this.fExpected != null && this.fActual != null;
    }

    public String getClassName() {
        return TestElement.extractClassName(this.getTestName());
    }

    private static String extractClassName(String testNameString) {
        testNameString = TestElement.extractRawClassName(testNameString);
        testNameString = testNameString.replace('$', '.');
        return testNameString;
    }

    public static String extractRawClassName(String testNameString) {
        int index = testNameString.indexOf(40);
        if (index < 0) {
            return testNameString;
        }
        testNameString = testNameString.substring(index + 1);
        testNameString = testNameString.substring(0, testNameString.indexOf(41));
        return testNameString;
    }

    public TestRoot getRoot() {
        return this.getParent().getRoot();
    }

    public void setElapsedTimeInSeconds(double time) {
        this.fTime = time;
    }

    public double getElapsedTimeInSeconds() {
        if (Double.isNaN(this.fTime) || this.fTime < 0.0) {
            return Double.NaN;
        }
        return this.fTime;
    }

    public static final class Status {
        public static final Status ERROR = new Status("ERROR");
        public static final Status OK = new Status("OK");
        private final String fName;

        private Status(String name) {
            this.fName = name;
        }

        public String toString() {
            return this.fName;
        }

        public boolean isOK() {
            return this == OK;
        }

        public boolean isError() {
            return this == ERROR;
        }

        public static Status combineStatus(Status one, Status two) {
            return Status.combineError(one, two);
        }

        private static Status combineError(Status one, Status two) {
            if (one.isError() || two.isError()) {
                return ERROR;
            }
            return OK;
        }

        public ITestElement.Result convertToResult() {
            if (this.isError()) {
                return ITestElement.Result.ERROR;
            }
            return ITestElement.Result.OK;
        }
    }
}

