/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.ui;

import com.atlassian.connector.eclipse.internal.bamboo.core.BambooClientManager;
import com.atlassian.connector.eclipse.internal.bamboo.core.BambooCorePlugin;
import com.atlassian.connector.eclipse.internal.bamboo.core.BambooUtil;
import com.atlassian.connector.eclipse.internal.bamboo.core.PlanBranches;
import com.atlassian.connector.eclipse.internal.bamboo.core.client.BambooClient;
import com.atlassian.connector.eclipse.internal.bamboo.core.client.BambooClientData;
import com.atlassian.connector.eclipse.internal.bamboo.ui.BambooLabelProvider;
import com.atlassian.connector.eclipse.internal.commons.ui.MigrateToSecureStorageJob;
import com.atlassian.connector.eclipse.internal.commons.ui.dialogs.RemoteApiLockedDialog;
import com.atlassian.theplugin.commons.bamboo.BambooPlan;
import com.atlassian.theplugin.commons.cfg.SubscribedPlan;
import com.atlassian.theplugin.commons.remoteapi.CaptchaRequiredException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.RowDataFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.commons.core.ICoreRunnable;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.commons.ui.CommonUiUtil;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.tasks.core.RepositoryTemplate;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BambooRepositorySettingsPage
extends AbstractRepositorySettingsPage {
    private static final int BUILD_PLAN_VIEWER_HEIGHT = 100;
    private CheckboxTreeViewer planViewer;
    private boolean validSettings;
    private boolean initialized;
    private Button btnUseFavourites;
    private Button selectAllButton;
    private Button deselectAllButton;
    private Button refreshButton;
    private Collection<BambooPlan> allPlans;
    private Combo btnPlanBranches;
    private Label planBranchesExplanationLabel;

    public BambooRepositorySettingsPage(TaskRepository taskRepository) {
        super("Bamboo Repository Settings", "Enter Bamboo server information", taskRepository);
        this.setNeedsHttpAuth(true);
        this.setNeedsEncoding(false);
        this.setNeedsAnonymousLogin(false);
        this.setNeedsAdvanced(false);
    }

    public void applyTo(TaskRepository repository) {
        this.repository = this.applyToValidate(repository);
        repository.setProperty("category", "org.eclipse.mylyn.category.build");
        BambooClientManager clientManager = BambooCorePlugin.getRepositoryConnector().getClientManager();
        BambooClient client = clientManager.getClient(repository);
        if (this.allPlans != null && client != null && client.getClientData() != null) {
            client.getClientData().setPlans(this.allPlans);
        }
        BambooUtil.setUseFavourites((TaskRepository)repository, (boolean)this.btnUseFavourites.getSelection());
        BambooUtil.setPlanBranches((TaskRepository)repository, (PlanBranches)PlanBranches.from((String)this.btnPlanBranches.getText()));
        Object[] items = this.planViewer.getCheckedElements();
        ArrayList<SubscribedPlan> plans = new ArrayList<SubscribedPlan>(items.length);
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (item instanceof BambooPlan) {
                plans.add(new SubscribedPlan(((BambooPlan)item).getKey()));
            }
            ++n2;
        }
        BambooUtil.setSubcribedPlans((TaskRepository)this.repository, plans);
        BambooCorePlugin.getBuildPlanManager().buildSubscriptionsChanged(this.repository);
    }

    public TaskRepository applyToValidate(TaskRepository repository) {
        MigrateToSecureStorageJob.migrateToSecureStorage((TaskRepository)repository);
        super.applyTo(repository);
        return repository;
    }

    public TaskRepository createTaskRepository() {
        TaskRepository repository = new TaskRepository(this.connector.getConnectorKind(), this.getRepositoryUrl());
        return this.applyToValidate(repository);
    }

    protected void createAdditionalControls(Composite parent) {
        this.addRepositoryTemplatesToServerUrlCombo();
    }

    protected void createContributionControls(Composite parent) {
        ExpandableComposite section = this.createSection(parent, "Build Plans");
        section.setExpanded(true);
        if (section.getLayoutData() instanceof GridData) {
            GridData gd = (GridData)section.getLayoutData();
            gd.grabExcessVerticalSpace = true;
            gd.verticalAlignment = 4;
        }
        Composite composite = new Composite((Composite)section, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        section.setClient((Control)composite);
        this.btnUseFavourites = new Button(composite, 32);
        this.btnUseFavourites.setText("Use Favourite Builds for Server");
        GridDataFactory.fillDefaults().span(2, 1).indent(0, 5).applyTo((Control)this.btnUseFavourites);
        this.planViewer = new CheckboxTreeViewer(composite, 2560);
        this.planViewer.setContentProvider((IContentProvider)new BuildPlanContentProvider());
        this.planViewer.setLabelProvider((IBaseLabelProvider)new BambooLabelProvider());
        this.setCachedPlanInput();
        int height = this.convertVerticalDLUsToPixels(100);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).hint(-1, height).applyTo(this.planViewer.getControl());
        Composite buttonComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)buttonComposite);
        RowLayout buttonLayout = new RowLayout(512);
        buttonLayout.fill = true;
        buttonComposite.setLayout((Layout)buttonLayout);
        this.selectAllButton = new Button(buttonComposite, 8);
        this.selectAllButton.setText("&Select All");
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object input = BambooRepositorySettingsPage.this.planViewer.getInput();
                if (!(input instanceof Collection)) {
                    BambooRepositorySettingsPage.this.validateSettings();
                }
                if ((input = BambooRepositorySettingsPage.this.planViewer.getInput()) instanceof Collection) {
                    BambooRepositorySettingsPage.this.planViewer.setCheckedElements(((Collection)input).toArray());
                }
            }
        });
        this.deselectAllButton = new Button(buttonComposite, 8);
        this.deselectAllButton.setText("&Deselect All");
        this.deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BambooRepositorySettingsPage.this.planViewer.setCheckedElements(new Object[0]);
            }
        });
        this.refreshButton = new Button(buttonComposite, 8);
        this.refreshButton.setText("Refresh");
        this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BambooRepositorySettingsPage.this.validateSettings();
            }
        });
        Composite planBranchesComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)planBranchesComposite);
        RowLayout planBranchesLayout = new RowLayout(256);
        planBranchesComposite.setLayout((Layout)planBranchesLayout);
        Composite labelComposite = new Composite(planBranchesComposite, 0);
        RowDataFactory.swtDefaults().applyTo((Control)labelComposite);
        RowLayout labelLayout = new RowLayout();
        labelLayout.marginLeft = 0;
        labelComposite.setLayout((Layout)labelLayout);
        Label planBranchesLabel = new Label(labelComposite, 0);
        planBranchesLabel.setText("Show Plan Branches: ");
        this.btnPlanBranches = new Combo(planBranchesComposite, 8);
        this.btnPlanBranches.setItems(PlanBranches.stringValues());
        this.btnPlanBranches.select(0);
        Composite labelComposite2 = new Composite(planBranchesComposite, 0);
        RowDataFactory.swtDefaults().applyTo((Control)labelComposite);
        RowLayout labelLayout2 = new RowLayout();
        labelComposite2.setLayout((Layout)labelLayout2);
        this.planBranchesExplanationLabel = new Label(labelComposite2, 0);
        this.planBranchesExplanationLabel.setText(" (shows only branches where I am the last commiter)");
        this.planBranchesExplanationLabel.setVisible(false);
        this.btnPlanBranches.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (PlanBranches.values()[BambooRepositorySettingsPage.this.btnPlanBranches.getSelectionIndex()] == PlanBranches.MINE) {
                    BambooRepositorySettingsPage.this.planBranchesExplanationLabel.setVisible(true);
                } else {
                    BambooRepositorySettingsPage.this.planBranchesExplanationLabel.setVisible(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnUseFavourites.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BambooRepositorySettingsPage.this.favouritesSelected(BambooRepositorySettingsPage.this.btnUseFavourites.getSelection());
            }
        });
        this.restoreOldValues();
    }

    private void restoreOldValues() {
        if (BambooUtil.isUseFavourites((TaskRepository)this.repository)) {
            this.btnUseFavourites.setSelection(true);
            this.favouritesSelected(true);
        }
        PlanBranches planBranches = BambooUtil.getPlanBranches((TaskRepository)this.repository);
        this.btnPlanBranches.select(planBranches.ordinal());
        if (planBranches == PlanBranches.MINE) {
            this.planBranchesExplanationLabel.setVisible(true);
        }
    }

    private void favouritesSelected(boolean enabled) {
        this.planViewer.getControl().setEnabled(!enabled);
        this.selectAllButton.setEnabled(!enabled);
        this.deselectAllButton.setEnabled(!enabled);
        this.refreshButton.setEnabled(!enabled);
    }

    private void setCachedPlanInput() {
        if (this.repository != null) {
            BambooClientManager clientManager = BambooCorePlugin.getRepositoryConnector().getClientManager();
            BambooClient client = clientManager.getClient(this.repository);
            this.updateUIRestoreState(new Object[0], client.getClientData());
        }
    }

    public String getConnectorKind() {
        return "bamboo";
    }

    protected AbstractRepositorySettingsPage.Validator getValidator(TaskRepository repository) {
        return new BambooValidator(repository);
    }

    protected boolean isValidUrl(String name) {
        if (name.startsWith("https://") || name.startsWith("http://")) {
            try {
                new URL(name);
                return true;
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return false;
    }

    protected void applyValidatorResult(AbstractRepositorySettingsPage.Validator validator) {
        this.validSettings = validator != null && validator.getStatus() == Status.OK_STATUS;
        super.applyValidatorResult(validator);
    }

    protected void validateSettings() {
        if (this.repository != null) {
            AuthenticationCredentials repoCredentials = this.repository.getCredentials(AuthenticationType.REPOSITORY);
            AuthenticationCredentials proxyCredentials = this.repository.getCredentials(AuthenticationType.PROXY);
            AuthenticationCredentials httpCredentials = this.repository.getCredentials(AuthenticationType.HTTP);
            super.validateSettings();
            if (this.validSettings && !this.btnUseFavourites.getSelection()) {
                this.refreshBuildPlans();
            }
            this.repository.setCredentials(AuthenticationType.REPOSITORY, repoCredentials, this.repository.getSavePassword(AuthenticationType.REPOSITORY));
            this.repository.setCredentials(AuthenticationType.HTTP, httpCredentials, this.repository.getSavePassword(AuthenticationType.HTTP));
            this.repository.setCredentials(AuthenticationType.PROXY, proxyCredentials, this.repository.getSavePassword(AuthenticationType.PROXY));
        } else {
            super.validateSettings();
            if (this.validSettings && !this.btnUseFavourites.getSelection()) {
                this.refreshBuildPlans();
            }
        }
    }

    private void refreshBuildPlans() {
        try {
            final TaskRepository repository = this.createTaskRepository();
            Object[] checkedElements = this.planViewer.getCheckedElements();
            final BambooClientData[] data = new BambooClientData[1];
            CommonUiUtil.run((IRunnableContext)this.getContainer(), (ICoreRunnable)new ICoreRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    BambooClientManager clientManager = BambooCorePlugin.getRepositoryConnector().getClientManager();
                    BambooClient client = clientManager.getNewClient(repository);
                    data[0] = client.updateRepositoryData(monitor, repository);
                    BambooRepositorySettingsPage.this.rememberPlans(client.getClientData().getPlans());
                    clientManager.removeClient(repository);
                }
            });
            if (data[0] != null) {
                this.updateUIRestoreState(checkedElements, data[0]);
            }
        }
        catch (CoreException e) {
            CommonUiUtil.setMessage((DialogPage)this, (IStatus)e.getStatus());
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    private void rememberPlans(Collection<BambooPlan> plans) {
        this.allPlans = plans;
    }

    private void updateUIRestoreState(Object[] checkedElements, BambooClientData data) {
        Collection plans = data.getPlans();
        if (plans != null) {
            this.planViewer.setInput((Object)plans);
            if (!this.initialized) {
                if (plans.size() > 0) {
                    this.initialized = true;
                    if (this.getRepository() != null) {
                        HashSet subscribedPlans = new HashSet(BambooUtil.getSubscribedPlans((TaskRepository)this.getRepository()));
                        for (BambooPlan plan : plans) {
                            if (!subscribedPlans.contains(new SubscribedPlan(plan.getKey()))) continue;
                            this.planViewer.setChecked((Object)plan, true);
                        }
                    } else {
                        for (BambooPlan plan : plans) {
                            if (!plan.isFavourite()) continue;
                            this.planViewer.setChecked((Object)plan, true);
                        }
                    }
                }
            } else {
                this.planViewer.setCheckedElements(checkedElements);
            }
        }
    }

    protected void repositoryTemplateSelected(RepositoryTemplate template) {
        this.repositoryLabelEditor.setStringValue(template.label);
        this.setUrl(template.repositoryUrl);
        this.getContainer().updateButtons();
    }

    private class BambooValidator
    extends AbstractRepositorySettingsPage.Validator {
        private final TaskRepository taskRepository;

        public BambooValidator(TaskRepository taskRepository) {
            super((AbstractRepositorySettingsPage)BambooRepositorySettingsPage.this);
            this.taskRepository = taskRepository;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            BambooClientManager clientManager = BambooCorePlugin.getRepositoryConnector().getClientManager();
            BambooClient client = null;
            try {
                try {
                    client = clientManager.createTempClient(this.taskRepository, new BambooClientData());
                    monitor = Policy.backgroundMonitorFor((IProgressMonitor)monitor);
                    client.validate(monitor, this.taskRepository);
                }
                catch (CoreException e) {
                    if (e.getCause() != null && e.getCause() instanceof CaptchaRequiredException) {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                new RemoteApiLockedDialog(WorkbenchUtil.getShell(), BambooValidator.this.taskRepository.getRepositoryUrl()).open();
                            }
                        });
                        this.setStatus((IStatus)new Status(4, "com.atlassian.connector.eclipse.bamboo.ui", "Wrong credentials or you've been locked out from remote API."));
                    } else if (e.getMessage().contains("Server returned malformed response")) {
                        this.setStatus((IStatus)new Status(e.getStatus().getSeverity(), e.getStatus().getPlugin(), String.valueOf(e.getStatus().getMessage()) + ". Server behind proxy?"));
                    } else {
                        this.setStatus(e.getStatus());
                    }
                    if (client != null) {
                        clientManager.deleteTempClient(client.getServerData());
                    }
                }
            }
            finally {
                if (client != null) {
                    clientManager.deleteTempClient(client.getServerData());
                }
            }
        }
    }

    private class BuildPlanContentProvider
    implements ITreeContentProvider {
        private BuildPlanContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

