/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jface.wizard.IWizardPage;
import org.springframework.ide.eclipse.config.ui.wizards.ExtendedNewClassWizardPage;

public class ExtendedNewClassCreationWizard
extends NewElementWizard {
    private ExtendedNewClassWizardPage mainPage;
    private final IProject project;
    private final String className;
    private final boolean openEditor;

    public ExtendedNewClassCreationWizard(IProject project, String className, boolean openEditorOnFinish) {
        this.project = project;
        this.className = className;
        this.openEditor = openEditorOnFinish;
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWCLASS);
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(NewWizardMessages.NewClassCreationWizard_title);
    }

    public void addPages() {
        if (this.mainPage == null) {
            this.mainPage = new ExtendedNewClassWizardPage(this.project, this.className);
            this.mainPage.init();
        }
        this.addPage((IWizardPage)this.mainPage);
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.mainPage.createType(monitor);
    }

    public IJavaElement getCreatedElement() {
        return this.mainPage.getCreatedType();
    }

    public String getQualifiedName() {
        if (this.mainPage.getCreatedType() == null) {
            return null;
        }
        return this.mainPage.getCreatedType().getFullyQualifiedName('$');
    }

    public boolean performFinish() {
        IResource resource;
        this.warnAboutTypeCommentDeprecation();
        boolean res = super.performFinish();
        if (res && (resource = this.mainPage.getModifiedResource()) != null) {
            this.selectAndReveal(resource);
            if (this.openEditor) {
                this.openResource((IFile)resource);
            }
        }
        return res;
    }
}

