/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.config.core.ConfigCoreUtils;
import org.springframework.ide.eclipse.config.core.contentassist.SpringConfigContentAssistProcessor;
import org.springframework.ide.eclipse.config.core.extensions.PageAdaptersExtensionPointConstants;
import org.springframework.ide.eclipse.config.ui.actions.CollapseNodeAction;
import org.springframework.ide.eclipse.config.ui.actions.DeleteNodeAction;
import org.springframework.ide.eclipse.config.ui.actions.ExpandNodeAction;
import org.springframework.ide.eclipse.config.ui.actions.InsertNodeAction;
import org.springframework.ide.eclipse.config.ui.actions.LowerNodeAction;
import org.springframework.ide.eclipse.config.ui.actions.RaiseNodeAction;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigFormPage;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigLabelProvider;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigMasterPart;
import org.springframework.ide.eclipse.config.ui.editors.Messages;
import org.springframework.ide.eclipse.config.ui.editors.SpringConfigContentProvider;
import org.springframework.ide.eclipse.config.ui.editors.SpringConfigLabelProvider;
import org.springframework.ide.eclipse.wizard.ui.BeanWizardDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNamespaceMasterPart
extends AbstractConfigMasterPart {
    private TreeViewer treeViewer;
    private SelectionChangedListener selectionListener;
    private Button newBeanButton;
    private Button upButton;
    private Button downButton;
    private static String SCHEMA_URI_PREFIX = "http://www.springframework.org/schema/";
    private final SpringConfigContentAssistProcessor xmlProcessor;

    public AbstractNamespaceMasterPart(AbstractConfigFormPage page, Composite parent) {
        super(page, parent);
        this.xmlProcessor = page.getXmlProcessor();
    }

    @Override
    protected void createButtons(Composite client) {
        GridData data = new GridData(768);
        data.widthHint = 100;
        this.newBeanButton = this.toolkit.createButton(client, Messages.getString("AbstractNamespaceMasterPart.NEW_BEAN_BUTTON"), 0x800000);
        this.newBeanButton.setLayoutData((Object)data);
        this.newBeanButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFile sourceFile = AbstractNamespaceMasterPart.this.getConfigEditor().getResourceFile();
                Shell shell = AbstractNamespaceMasterPart.this.getFormPage().getSite().getShell();
                if (shell != null && !shell.isDisposed()) {
                    BeanWizardDialog dialog = BeanWizardDialog.createBeanWizardDialog((Shell)shell, (IFile)sourceFile, (boolean)false);
                    dialog.create();
                    dialog.setBlockOnOpen(true);
                    if (dialog.open() == 0) {
                        IDOMElement element = dialog.getNewBean();
                        AbstractNamespaceMasterPart.this.getViewer().setSelection((ISelection)new StructuredSelection((Object)element));
                    }
                }
            }
        });
        this.upButton = this.toolkit.createButton(client, Messages.getString("AbstractNamespaceMasterPart.MOVE_UP_BUTTON"), 0x800000);
        this.upButton.setLayoutData((Object)data);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredTextViewer textView = AbstractNamespaceMasterPart.this.getConfigEditor().getTextViewer();
                RaiseNodeAction action = new RaiseNodeAction(AbstractNamespaceMasterPart.this.treeViewer, AbstractNamespaceMasterPart.this.xmlProcessor, textView);
                action.run();
            }
        });
        this.upButton.setEnabled(false);
        this.downButton = this.toolkit.createButton(client, Messages.getString("AbstractNamespaceMasterPart.MOVE_DOWN_BUTTON"), 0x800000);
        this.downButton.setLayoutData((Object)data);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredTextViewer textView = AbstractNamespaceMasterPart.this.getConfigEditor().getTextViewer();
                LowerNodeAction action = new LowerNodeAction(AbstractNamespaceMasterPart.this.treeViewer, AbstractNamespaceMasterPart.this.xmlProcessor, textView);
                action.run();
            }
        });
        this.downButton.setEnabled(false);
    }

    protected abstract void createEmptyDocumentActions(IMenuManager var1, IDOMDocument var2);

    protected void createNodeInsertActions(IMenuManager manager, IDOMElement parent) {
        StructuredTextViewer textView = this.getConfigEditor().getTextViewer();
        Map<String, List<String>> childMap = this.getChildNames(parent);
        if (childMap.keySet().size() > 1) {
            for (String prefix : childMap.keySet()) {
                MenuManager subManager;
                if (prefix.trim().equals("")) {
                    int pos;
                    String uri = ConfigCoreUtils.getDefaultNamespaceUri((IDOMDocument)this.getConfigEditor().getDomDocument());
                    if (uri == null) {
                        uri = "http://www.springframework.org/schema/beans";
                    }
                    String label = (pos = uri.indexOf(SCHEMA_URI_PREFIX)) > -1 ? uri.substring(pos + SCHEMA_URI_PREFIX.length(), uri.length()) : Messages.getString("AbstractNamespaceMasterPart.DEFAULT_NAMESPACE_SUBMENU");
                    subManager = new MenuManager(label);
                } else {
                    subManager = new MenuManager(prefix);
                }
                for (String childName : childMap.get(prefix)) {
                    subManager.add((IAction)new InsertNodeAction(this.treeViewer, this.xmlProcessor, textView, childName));
                }
                manager.add((IContributionItem)subManager);
            }
        } else {
            for (String prefix : childMap.keySet()) {
                for (String childName : childMap.get(prefix)) {
                    manager.add((IAction)new InsertNodeAction(this.treeViewer, this.xmlProcessor, textView, childName));
                }
            }
        }
    }

    @Override
    protected ColumnViewer createViewer(Composite client) {
        FilteredTree filter = new FilteredTree(client, 2050, new PatternFilter(), true);
        this.treeViewer = filter.getViewer();
        return this.treeViewer;
    }

    @Override
    protected SpringConfigContentProvider createViewerContentProvider() {
        return new SpringConfigContentProvider(this.getFormPage());
    }

    @Override
    protected AbstractConfigLabelProvider createViewerLabelProvider() {
        return new SpringConfigLabelProvider();
    }

    public void dispose() {
        if (this.treeViewer != null && this.selectionListener != null) {
            this.treeViewer.removeSelectionChangedListener((ISelectionChangedListener)this.selectionListener);
        }
        super.dispose();
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        StructuredTextViewer textView = this.getConfigEditor().getTextViewer();
        if (!selection.isEmpty()) {
            Object obj = selection.getFirstElement();
            if (obj != null && obj instanceof IDOMElement) {
                IDOMElement node = (IDOMElement)obj;
                this.createNodeInsertActions(manager, node);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new DeleteNodeAction(textView, (IDOMNode)node));
            }
        } else {
            IDOMDocument doc = this.getConfigEditor().getDomDocument();
            if (doc != null) {
                this.createEmptyDocumentActions(manager, doc);
            }
        }
    }

    protected Map<String, List<String>> getChildNames(IDOMElement parent) {
        SpringConfigContentAssistProcessor proc = this.getFormPage().getXmlProcessor();
        Node grandParent = parent.getParentNode();
        TreeMap<String, List<String>> childMap = new TreeMap<String, List<String>>();
        if (proc != null) {
            List list = proc.getChildNames(parent);
            String uri = this.getFormPage().getNamespaceUri();
            for (String name : list) {
                String prefix = "";
                int pos = name.indexOf(58);
                if (pos > -1) {
                    prefix = name.substring(0, pos);
                }
                List names = childMap.containsKey(prefix) ? (List)childMap.get(prefix) : new ArrayList();
                if (grandParent instanceof Document && uri != null) {
                    String prefixForUri = this.getFormPage().getPrefixForNamespaceUri();
                    if (!prefix.equals(prefixForUri) && !this.isAdapterNamespacePrefix(prefix)) continue;
                    names.add(name);
                    childMap.put(prefix, names);
                    continue;
                }
                names.add(name);
                childMap.put(prefix, names);
            }
        }
        return childMap;
    }

    @Override
    protected String getSectionDescription() {
        return Messages.getString("AbstractNamespaceMasterPart.SECTION_DESCRIPTION");
    }

    private boolean isAdapterNamespacePrefix(String prefix) {
        if (prefix != null) {
            for (IConfigurationElement config : this.getFormPage().getAdapterDefinitions()) {
                String adapterPrefix = ConfigCoreUtils.getPrefixForNamespaceUri((IDOMDocument)this.getConfigEditor().getDomDocument(), (String)config.getAttribute(PageAdaptersExtensionPointConstants.ATTR_NAMESPACE_URI));
                if (adapterPrefix == null || !adapterPrefix.equals(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void postCreateContents() {
        if (this.treeViewer != null) {
            this.selectionListener = new SelectionChangedListener();
            this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this.selectionListener);
            ToolBarManager manager = this.getToolBarManager();
            manager.add((IAction)new CollapseNodeAction(this.treeViewer, this.xmlProcessor));
            manager.add((IAction)new ExpandNodeAction(this.treeViewer, this.xmlProcessor));
            this.treeViewer.expandToLevel(2);
        }
    }

    @Override
    public void refresh() {
        if (this.newBeanButton != null) {
            IDOMDocument document = this.getConfigEditor().getDomDocument();
            if (document == null || document.getDocumentElement() == null) {
                this.newBeanButton.setEnabled(false);
            } else {
                this.newBeanButton.setEnabled(true);
            }
        }
        super.refresh();
    }

    private class SelectionChangedListener
    implements ISelectionChangedListener {
        private SelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (AbstractNamespaceMasterPart.this.upButton != null && AbstractNamespaceMasterPart.this.downButton != null) {
                ISelection selection = AbstractNamespaceMasterPart.this.treeViewer.getSelection();
                int count = AbstractNamespaceMasterPart.this.treeViewer.getTree().getSelectionCount();
                if (selection.isEmpty() || count > 1) {
                    AbstractNamespaceMasterPart.this.upButton.setEnabled(false);
                    AbstractNamespaceMasterPart.this.downButton.setEnabled(false);
                } else {
                    AbstractNamespaceMasterPart.this.upButton.setEnabled(true);
                    AbstractNamespaceMasterPart.this.downButton.setEnabled(true);
                }
            }
        }
    }
}

