/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfig;
import org.springframework.ide.eclipse.beans.mylyn.ui.IBeansXmlEditor;
import org.springframework.ide.eclipse.config.core.ConfigCoreUtils;
import org.springframework.ide.eclipse.config.core.IConfigEditor;
import org.springframework.ide.eclipse.config.core.IConfigEditorPage;
import org.springframework.ide.eclipse.config.core.contentassist.SpringConfigContentAssistProcessor;
import org.springframework.ide.eclipse.config.core.extensions.FormPagesExtensionPointConstants;
import org.springframework.ide.eclipse.config.core.extensions.PageAdaptersExtensionPointConstants;
import org.springframework.ide.eclipse.config.graph.AbstractConfigGraphicalEditor;
import org.springframework.ide.eclipse.config.ui.ConfigUiPlugin;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigFormPage;
import org.springframework.ide.eclipse.config.ui.editors.Messages;
import org.springframework.ide.eclipse.config.ui.editors.SpringConfigContentOutline;
import org.springframework.ide.eclipse.config.ui.editors.SpringConfigEditorContributor;
import org.springframework.ide.eclipse.config.ui.editors.SpringConfigHeaderMessage;
import org.springframework.ide.eclipse.config.ui.extensions.ConfigUiExtensionPointReader;
import org.springframework.ide.eclipse.config.ui.properties.AbstractConfigPropertySection;
import org.springframework.ide.eclipse.config.ui.properties.SpringConfigPropertySheetPage;
import org.springframework.ide.eclipse.core.model.IModelChangeListener;
import org.springframework.ide.eclipse.core.model.ModelChangeEvent;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.springsource.ide.eclipse.commons.ui.UiStatusHandler;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigEditor
extends FormEditor
implements IBeansXmlEditor,
IConfigEditor,
IGotoMarker,
IModelChangeListener,
IPropertyChangeListener,
ITabbedPropertySheetPageContributor,
ITextListener {
    private static String KEY_ACTIVE_PAGE = "activePage";
    private static String KEY_PAGE_ID = "id";
    private static String KEY_PAGE_URI = "uri";
    private static String KEY_PAGE_KIND = "kind";
    private static String KEY_PAGE_INDEX = "index";
    private StructuredTextEditor sourceEditor;
    private final SpringConfigContentAssistProcessor xmlProcessor;
    private final SpringConfigContentOutline contentOutline;
    private final SpringConfigHeaderMessage headerMessage;
    private Set<String> selectedNamespaceUris = Collections.emptySet();
    private IEditorInput editorInput;
    private IFile resource;
    private final ResourceChangeListener resourceListener;
    private IDOMModel model;
    private IDOMDocument domDocument;
    private final IPreferenceStore prefStore;
    private String activePageKey;
    private final Set<AbstractConfigPropertySection> propertiesPages = new HashSet<AbstractConfigPropertySection>();
    private boolean isGraphDemo = false;

    public AbstractConfigEditor() {
        this.xmlProcessor = new SpringConfigContentAssistProcessor();
        this.headerMessage = new SpringConfigHeaderMessage(this);
        this.contentOutline = new SpringConfigContentOutline(this);
        this.resourceListener = new ResourceChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener);
        BeansCorePlugin.getModel().addChangeListener((IModelChangeListener)this);
        this.prefStore = ConfigUiPlugin.getDefault().getPreferenceStore();
        this.prefStore.addPropertyChangeListener((IPropertyChangeListener)this);
        this.enableGraphDemo();
    }

    protected void addConfigEditorPage(IConfigEditorPage page, String pageText) {
        try {
            boolean added = false;
            for (Object obj : this.pages) {
                int i;
                if (!(obj instanceof IConfigEditorPage) || pageText.compareTo(this.getPageText(i = this.pages.indexOf(obj))) >= 0) continue;
                if (page instanceof IFormPage) {
                    this.addPage(i, (IFormPage)page);
                } else {
                    this.addPage(i, (IEditorPart)page, this.getEditorInput());
                }
                this.setPageText(i, pageText);
                added = true;
                break;
            }
            if (!added) {
                int i = page instanceof IFormPage ? this.addPage((IFormPage)page) : this.addPage((IEditorPart)page, this.getEditorInput());
                this.setPageText(i, pageText);
            }
        }
        catch (PartInitException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.config.ui", Messages.getString("SpringConfigEditor.ERROR_CREATING_EDITOR_PAGE"), (Throwable)e));
        }
    }

    protected void addPages() {
        this.createSourcePage();
        if (this.resource instanceof IFile) {
            this.createPreNamespacePages();
            this.createNamespacePages();
        }
        this.loadActivePage();
    }

    public void addPropertiesPage(AbstractConfigPropertySection propertiesPage) {
        this.propertiesPages.add(propertiesPage);
    }

    public boolean containsNamespaceUri(String uri) {
        return this.selectedNamespaceUris.contains(uri);
    }

    private IConfigEditorPage createConfigEditorPage(IConfigurationElement definition, String property) {
        try {
            Object obj = definition.createExecutableExtension(property);
            if (obj instanceof IConfigEditorPage) {
                IConfigEditorPage page = (IConfigEditorPage)obj;
                page.initialize((IConfigEditor)this, definition.getAttribute(FormPagesExtensionPointConstants.ATTR_NAMESPACE_URI));
                return page;
            }
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.config.ui", Messages.getString("SpringConfigEditor.ERROR_INITIALIZING_EDITOR_PAGE"), (Throwable)e));
        }
        return null;
    }

    private void createNamespacePages() {
        this.selectedNamespaceUris = this.readNamespacesFromFile();
        this.updateNamespacePages();
    }

    protected abstract void createPreNamespacePages();

    protected IEditorSite createSite(IEditorPart page) {
        Object site = null;
        site = page == this.sourceEditor ? new MultiPageEditorSite((MultiPageEditorPart)this, page){

            public IEditorActionBarContributor getActionBarContributor() {
                IEditorActionBarContributor contributor = super.getActionBarContributor();
                IEditorActionBarContributor multiContributor = AbstractConfigEditor.this.getEditorSite().getActionBarContributor();
                if (multiContributor instanceof SpringConfigEditorContributor) {
                    contributor = ((SpringConfigEditorContributor)multiContributor).sourceViewerActionContributor;
                }
                return contributor;
            }

            public String getId() {
                return String.valueOf(ContentTypeIdForXML.ContentTypeID_XML) + ".source";
            }
        } : super.createSite(page);
        return site;
    }

    private void createSourcePage() {
        try {
            this.sourceEditor = new StructuredTextEditor(){

                public void selectAndReveal(int start, int length) {
                    AbstractConfigEditor.this.setActiveEditor((IEditorPart)AbstractConfigEditor.this.sourceEditor);
                    super.selectAndReveal(start, length);
                }
            };
            int index = this.addPage((IEditorPart)this.sourceEditor, this.getEditorInput());
            this.setPageText(index, Messages.getString("SpringConfigEditor.SOURCE_TAB"));
            this.setPartName(this.sourceEditor.getTitle());
            this.sourceEditor.setEditorPart((IEditorPart)this);
            this.sourceEditor.getTextViewer().addTextListener((ITextListener)this);
        }
        catch (PartInitException e) {
            UiStatusHandler.logAndDisplay((IStatus)new Status(4, "org.springframework.ide.eclipse.config.ui", Messages.getString("SpringConfigEditor.ERROR_CREATING_SOURCE_PAGE"), (Throwable)e));
        }
    }

    public void dispose() {
        this.xmlProcessor.release();
        this.sourceEditor.getTextViewer().removeTextListener((ITextListener)this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
        BeansCorePlugin.getModel().removeChangeListener((IModelChangeListener)this);
        this.prefStore.removePropertyChangeListener((IPropertyChangeListener)this);
        this.releaseModel();
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.sourceEditor.doSave(monitor);
        for (Object obj : this.pages) {
            if (!(obj instanceof IConfigEditorPage)) continue;
            IConfigEditorPage page = (IConfigEditorPage)obj;
            page.doSave(monitor);
        }
    }

    public void doSaveAs() {
        this.releaseModel();
        this.sourceEditor.doSaveAs();
        this.setPartName(this.sourceEditor.getTitle());
        this.setInput(this.sourceEditor.getEditorInput());
        for (Object obj : this.pages) {
            if (!(obj instanceof IConfigEditorPage)) continue;
            IConfigEditorPage page = (IConfigEditorPage)obj;
            page.doSaveAs();
        }
    }

    public void elementChanged(ModelChangeEvent event) {
        IResource resource;
        Object source = event.getSource();
        if (source instanceof BeansConfig && (resource = ((BeansConfig)source).getElementResource()) != null && resource.equals((Object)this.resource)) {
            this.headerMessage.updateMessage();
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (AbstractConfigEditor.this.pages != null) {
                        for (Object obj : AbstractConfigEditor.this.pages) {
                            if (!(obj instanceof AbstractConfigFormPage)) continue;
                            AbstractConfigFormPage page = (AbstractConfigFormPage)((Object)obj);
                            page.updateHeader();
                        }
                    }
                }
            });
        }
    }

    private void enableGraphDemo() {
        List<String> commandLineArgs = Arrays.asList(Platform.getCommandLineArgs());
        if (commandLineArgs.contains("-graphdemo")) {
            this.isGraphDemo = true;
        }
    }

    public Object getAdapter(Class adapter) {
        if (IPropertySheetPage.class == adapter) {
            return new SpringConfigPropertySheetPage(this);
        }
        if (IContentOutlinePage.class == adapter) {
            return this.contentOutline;
        }
        if (ITextEditor.class == adapter) {
            return this.sourceEditor;
        }
        Object result = super.getAdapter(adapter);
        if (result == null && this.sourceEditor != null) {
            result = this.sourceEditor.getAdapter(adapter);
        }
        return result;
    }

    public Set<IConfigurationElement> getAdapterDefinitions() {
        return ConfigUiExtensionPointReader.getAdapterDefinitions();
    }

    public SpringConfigContentOutline getContentOutline() {
        return this.contentOutline;
    }

    public String getContributorId() {
        return "com.springsource.sts.config.ui.editors.AbstractConfigEditor";
    }

    public IDOMDocument getDomDocument() {
        return this.domDocument;
    }

    public AbstractConfigFormPage getFormPage(String id) {
        if (id != null && !id.trim().equals("")) {
            for (Object obj : this.pages) {
                AbstractConfigFormPage page;
                if (!(obj instanceof AbstractConfigFormPage) || !id.equals((page = (AbstractConfigFormPage)((Object)obj)).getId())) continue;
                return page;
            }
        }
        return null;
    }

    public AbstractConfigFormPage getFormPageForAdapterUri(String uri) {
        AbstractConfigFormPage page = this.getFormPageForUri(uri);
        if (page != null) {
            return page;
        }
        if (uri != null && !uri.trim().equals("")) {
            for (Object obj : this.pages) {
                if (!(obj instanceof AbstractConfigFormPage)) continue;
                page = (AbstractConfigFormPage)((Object)obj);
                for (IConfigurationElement config : page.getAdapterDefinitions()) {
                    if (!uri.equals(config.getAttribute(PageAdaptersExtensionPointConstants.ATTR_NAMESPACE_URI))) continue;
                    return page;
                }
            }
        }
        return null;
    }

    public AbstractConfigFormPage getFormPageForUri(String uri) {
        if (uri != null && !uri.trim().equals("")) {
            for (Object obj : this.pages) {
                AbstractConfigFormPage page;
                if (!(obj instanceof AbstractConfigFormPage) || !uri.equals((page = (AbstractConfigFormPage)((Object)obj)).getNamespaceUri())) continue;
                return page;
            }
        }
        return null;
    }

    public AbstractConfigGraphicalEditor getGraphicalEditorForAdapterUri(String uri) {
        AbstractConfigGraphicalEditor page = this.getGraphicalEditorForUri(uri);
        if (page != null) {
            return page;
        }
        if (uri != null && !uri.trim().equals("")) {
            for (Object obj : this.pages) {
                if (!(obj instanceof AbstractConfigGraphicalEditor)) continue;
                page = (AbstractConfigGraphicalEditor)obj;
                for (IConfigurationElement config : page.getAdapterDefinitions()) {
                    if (!uri.equals(config.getAttribute(PageAdaptersExtensionPointConstants.ATTR_NAMESPACE_URI))) continue;
                    return page;
                }
            }
        }
        return null;
    }

    public AbstractConfigGraphicalEditor getGraphicalEditorForUri(String uri) {
        if (uri != null && !uri.trim().equals("")) {
            for (Object obj : this.pages) {
                if (!(obj instanceof AbstractConfigGraphicalEditor)) continue;
                AbstractConfigGraphicalEditor page = (AbstractConfigGraphicalEditor)obj;
                if (uri.equals(page.getNamespaceUri())) {
                    return page;
                }
                for (IConfigurationElement config : page.getAdapterDefinitions()) {
                    if (!uri.equals(config.getAttribute(PageAdaptersExtensionPointConstants.ATTR_NAMESPACE_URI))) continue;
                    return page;
                }
            }
        }
        return null;
    }

    public SpringConfigHeaderMessage getHeaderMessage() {
        return this.headerMessage;
    }

    public Set<IConfigurationElement> getPageDefinitions() {
        return ConfigUiExtensionPointReader.getPageDefinitions();
    }

    public IPreferenceStore getPreferenceStore() {
        return this.prefStore;
    }

    public IFile getResourceFile() {
        return this.resource;
    }

    public StructuredTextEditor getSourcePage() {
        return this.sourceEditor;
    }

    public StructuredTextViewer getTextViewer() {
        return this.sourceEditor.getTextViewer();
    }

    public Set<IConfigurationElement> getWizardDefinitions() {
        return ConfigUiExtensionPointReader.getWizardDefinitions();
    }

    public SpringConfigContentAssistProcessor getXmlProcessor() {
        return this.xmlProcessor;
    }

    public void gotoMarker(IMarker marker) {
        this.setActiveEditor((IEditorPart)this.sourceEditor);
        IDE.gotoMarker((IEditorPart)this.sourceEditor, (IMarker)marker);
    }

    private boolean isNamespaceChange() {
        Set<String> namespaceUris = this.selectedNamespaceUris;
        this.selectedNamespaceUris = this.readNamespacesFromFile();
        return !namespaceUris.equals(this.selectedNamespaceUris);
    }

    public boolean isSaveAsAllowed() {
        return this.sourceEditor != null && this.sourceEditor.isSaveAsAllowed();
    }

    public boolean isSaveOnCloseNeeded() {
        if (this.sourceEditor != null) {
            return this.sourceEditor.isSaveOnCloseNeeded();
        }
        return super.isSaveOnCloseNeeded();
    }

    private void loadActivePage() {
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor != null && contributor instanceof SpringConfigEditorContributor) {
            ((SpringConfigEditorContributor)contributor).setActiveEditor((IEditorPart)this);
        }
        this.loadActivePagePreference();
    }

    private void loadActivePagePreference() {
        AbstractConfigFormPage activePage = null;
        Integer index = null;
        String xml = this.prefStore.getString(this.activePageKey);
        if (xml != null && xml.length() > 0) {
            try {
                XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(xml));
                String id = memento.getString(KEY_PAGE_ID);
                String uri = memento.getString(KEY_PAGE_URI);
                String kind = memento.getString(KEY_PAGE_KIND);
                index = memento.getInteger(KEY_PAGE_INDEX);
                if (uri != null) {
                    if (AbstractConfigFormPage.PAGE_KIND.equals(kind)) {
                        activePage = this.getFormPageForUri(uri);
                    } else if (AbstractConfigGraphicalEditor.PAGE_KIND.equals(kind)) {
                        activePage = this.getGraphicalEditorForUri(uri);
                    }
                }
                if (activePage == null && id != null) {
                    activePage = this.getFormPage(id);
                }
            }
            catch (WorkbenchException e) {
                StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.config.ui", Messages.getString("SpringConfigEditor.ERROR_LOADING_ACTIVE_PAGE"), (Throwable)e));
                this.setActiveEditor((IEditorPart)this.sourceEditor);
            }
        }
        this.setActivePageFromPreference(index, activePage);
    }

    private void notifyModelChanged(boolean updateNamespaces) {
        for (Object obj : this.pages) {
            if (!(obj instanceof IConfigEditorPage)) continue;
            IConfigEditorPage page = (IConfigEditorPage)obj;
            page.modelUpdated();
            if (!updateNamespaces) continue;
            page.namespacesUpdated();
        }
        for (AbstractConfigPropertySection propertiesPage : this.propertiesPages) {
            propertiesPage.refresh();
        }
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        this.saveActivePagePreference(newPageIndex);
        this.updateContentOutline(newPageIndex);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("com.springsource.config.ui.prefs.enable.gef".equals(property)) {
            this.updateNamespacePages();
        }
    }

    private Set<String> readNamespacesFromFile() {
        HashSet<String> namespaceUris = new HashSet<String>();
        if (this.domDocument != null) {
            List schemaInfo;
            Element rootElement = this.domDocument.getDocumentElement();
            if (rootElement != null) {
                NamedNodeMap beanAttributes = rootElement.getAttributes();
                int i = 0;
                while (i < beanAttributes.getLength()) {
                    Node currAttr = beanAttributes.item(i);
                    String currAttrName = currAttr.getNodeName().trim();
                    String currAttrValue = currAttr.getNodeValue().trim();
                    if (currAttrName.startsWith(ConfigCoreUtils.ATTR_DEFAULT_NAMESPACE)) {
                        namespaceUris.add(currAttrValue);
                    }
                    ++i;
                }
            }
            if ((schemaInfo = ConfigCoreUtils.parseSchemaLocationAttr((IDOMDocument)this.domDocument)) != null) {
                Iterator iterator = schemaInfo.iterator();
                while (iterator.hasNext()) {
                    String currSchema = (String)iterator.next();
                    if (!namespaceUris.contains(currSchema)) {
                        namespaceUris.add(currSchema);
                    }
                    if (!iterator.hasNext()) continue;
                    iterator.next();
                }
            }
        }
        return namespaceUris;
    }

    private void releaseModel() {
        if (this.model != null) {
            this.model.releaseFromEdit();
            this.model = null;
        }
    }

    private void removeFormPage(String uri) {
        AbstractConfigFormPage page = this.getFormPageForUri(uri);
        if (page != null) {
            this.removePage(this.pages.indexOf((Object)page));
        }
    }

    private void removeGraphicalEditor(String uri) {
        AbstractConfigGraphicalEditor gEditor = this.getGraphicalEditorForUri(uri);
        if (gEditor != null) {
            this.removePage(this.pages.indexOf(gEditor));
        }
    }

    public void removePropertiesPage(AbstractConfigPropertySection propertiesPage) {
        this.propertiesPages.remove((Object)propertiesPage);
    }

    private void resolveModel() {
        if (this.editorInput instanceof IFileEditorInput) {
            this.resource = ((IFileEditorInput)this.editorInput).getFile();
            IStructuredModel structModel = StructuredModelManager.getModelManager().getExistingModelForEdit(this.resource);
            if (structModel == null) {
                try {
                    structModel = StructuredModelManager.getModelManager().getModelForEdit(this.resource);
                }
                catch (IOException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.config.ui", Messages.getString("SpringConfigEditor.ERROR_LOADING_EDITOR_MODEL"), (Throwable)e));
                }
                catch (CoreException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.config.ui", Messages.getString("SpringConfigEditor.ERROR_LOADING_EDITOR_MODEL"), (Throwable)e));
                }
            }
            if (structModel != null) {
                if (structModel instanceof IDOMModel) {
                    this.releaseModel();
                    this.model = (IDOMModel)structModel;
                    this.domDocument = this.model.getDocument();
                } else {
                    structModel.releaseFromEdit();
                }
            }
        }
        this.headerMessage.updateMessage();
    }

    public void revealElement(Node element) {
        AbstractConfigFormPage page;
        String uri = element.getNamespaceURI();
        if (uri != null && (page = this.getFormPageForUri(uri)) != null) {
            this.setActivePage(page.getId());
            page.setSelection((ISelection)new StructuredSelection((Object)element));
        }
    }

    private void saveActivePagePreference(int newPageIndex) {
        Object activePage = this.pages.get(newPageIndex);
        String xml = null;
        XMLMemento memento = XMLMemento.createWriteRoot((String)KEY_ACTIVE_PAGE);
        if (activePage instanceof IFormPage) {
            IFormPage formPage = (IFormPage)activePage;
            memento.putString(KEY_PAGE_ID, formPage.getId());
        }
        if (activePage instanceof IConfigEditorPage) {
            IConfigEditorPage configPage = (IConfigEditorPage)activePage;
            memento.putString(KEY_PAGE_URI, configPage.getNamespaceUri());
            memento.putString(KEY_PAGE_KIND, configPage.getPageKind());
        }
        memento.putInteger(KEY_PAGE_INDEX, newPageIndex);
        try {
            StringWriter writer = new StringWriter();
            memento.save((Writer)writer);
            xml = writer.getBuffer().toString();
            this.prefStore.setValue(this.activePageKey, xml);
        }
        catch (IOException iOException) {
            StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.config.ui", Messages.getString("SpringConfigEditor.ERROR_SAVING_ACTIVE_PAGE")));
        }
    }

    protected void setActivePageFromPreference(Integer index, IConfigEditorPage activePage) {
        if (activePage != null) {
            this.setActivePage(this.pages.indexOf(activePage));
        } else {
            this.setActiveEditor((IEditorPart)this.sourceEditor);
        }
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.setInputHelper(input);
    }

    private void setInputHelper(IEditorInput input) {
        this.editorInput = input;
        this.resolveModel();
        this.activePageKey = this.resource != null ? "com.springsource.config.ui.prefs.activePageIndex:" + this.resource.getFullPath().toString() : "com.springsource.config.ui.prefs.activePageIndex";
    }

    protected void setInputWithNotify(IEditorInput input) {
        super.setInputWithNotify(input);
        this.setInputHelper(input);
    }

    public void textChanged(TextEvent event) {
        if ((event.getText() != null || event.getReplacedText() != null) && event.getDocumentEvent() != null && event.getDocumentEvent().getText() != null) {
            boolean updateNamespaces = this.isNamespaceChange();
            if (updateNamespaces) {
                this.updateNamespacePages();
            }
            this.notifyModelChanged(updateNamespaces);
        }
    }

    protected void updateContentOutline(int newPageIndex) {
        if (this.contentOutline != null) {
            IContentOutlinePage outline = null;
            Object activePage = this.pages.get(newPageIndex);
            outline = activePage instanceof AbstractConfigGraphicalEditor ? (IContentOutlinePage)((AbstractConfigGraphicalEditor)activePage).getAdapter(IContentOutlinePage.class) : (IContentOutlinePage)this.sourceEditor.getAdapter(IContentOutlinePage.class);
            if (outline != null) {
                this.contentOutline.setActiveOutline(outline);
            }
        }
    }

    protected void updateNamespacePages() {
        boolean gefEnabled = this.prefStore.getBoolean("com.springsource.config.ui.prefs.enable.gef");
        Set<IConfigurationElement> pageDefinitions = ConfigUiExtensionPointReader.getPageDefinitions();
        for (IConfigurationElement def : pageDefinitions) {
            String uri = def.getAttribute(FormPagesExtensionPointConstants.ATTR_NAMESPACE_URI);
            if (this.containsNamespaceUri(uri)) {
                String prefix = def.getAttribute(FormPagesExtensionPointConstants.ATTR_NAMESPACE_PREFIX);
                if (this.getFormPageForUri(uri) == null) {
                    IConfigEditorPage page = this.createConfigEditorPage(def, FormPagesExtensionPointConstants.ATTR_CLASS);
                    this.addConfigEditorPage(page, prefix);
                }
                if (gefEnabled) {
                    String graph;
                    if (this.getGraphicalEditorForUri(uri) != null || (graph = def.getAttribute(FormPagesExtensionPointConstants.ATTR_GRAPH)) == null || graph.trim().length() <= 0) continue;
                    String graphPrefix = prefix.concat("-graph");
                    IConfigEditorPage gEditor = this.createConfigEditorPage(def, FormPagesExtensionPointConstants.ATTR_GRAPH);
                    this.addConfigEditorPage(gEditor, graphPrefix);
                    continue;
                }
                this.removeGraphicalEditor(uri);
                continue;
            }
            this.removeFormPage(uri);
            this.removeGraphicalEditor(uri);
        }
    }

    private class ResourceChangeListener
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() == 2 || event.getType() == 4) {
                IResource file;
                IProject project = null;
                if (event.getSource() instanceof IWorkspace) {
                    project = (IProject)event.getResource();
                } else if (event.getSource() instanceof IProject) {
                    project = (IProject)event.getSource();
                }
                if (project != null && (file = project.findMember(AbstractConfigEditor.this.getResourceFile().getFullPath())) != null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            AbstractConfigEditor.this.getSite().getPage().closeEditor((IEditorPart)AbstractConfigEditor.this, true);
                        }
                    });
                }
            } else if (event.getType() == 1) {
                IResourceDelta delta = event.getDelta();
                try {
                    if (delta != null) {
                        delta.accept((IResourceDeltaVisitor)this);
                    }
                }
                catch (CoreException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.config.ui", Messages.getString("SpringConfigEditor.ERROR_PROCESSING_RESOURCE_CHANGE"), (Throwable)e));
                }
            }
        }

        public boolean visit(IResourceDelta root) throws CoreException {
            IResourceDelta delta;
            if (root != null && AbstractConfigEditor.this.getResourceFile() != null && (delta = root.findMember(AbstractConfigEditor.this.getResourceFile().getFullPath())) != null && delta.getKind() == 2) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        AbstractConfigEditor.this.getSite().getPage().closeEditor((IEditorPart)AbstractConfigEditor.this, true);
                    }
                });
            }
            return false;
        }
    }
}

