/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.contenttype;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.internal.content.ContentMessages;
import org.eclipse.core.internal.content.XMLRootHandler;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.XMLContentDescriber;
import org.springframework.ide.eclipse.beans.ui.namespaces.INamespaceDefinition;
import org.springframework.ide.eclipse.beans.ui.namespaces.NamespaceUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class SpringElementContentDescriber
extends XMLContentDescriber {
    private int checkCriteria(InputSource contents) throws IOException {
        XMLRootHandler xmlHandler = new XMLRootHandler(true);
        try {
            if (!xmlHandler.parseContents(contents)) {
                return 1;
            }
        }
        catch (SAXException sAXException) {
            return 1;
        }
        catch (ParserConfigurationException e) {
            String message = ContentMessages.content_parserConfiguration;
            RuntimeLog.log((IStatus)new Status(4, "org.eclipse.core.contenttype", 0, message, (Throwable)e));
            throw new RuntimeException(message);
        }
        String ns = xmlHandler.getRootNamespace();
        if (ns.startsWith("http://www.springframework.org/schema/beans")) {
            return 2;
        }
        if (ns != null) {
            for (INamespaceDefinition namespaceDefinition : NamespaceUtils.getNamespaceDefinitions()) {
                if (!ns.equals(namespaceDefinition.getNamespaceURI())) continue;
                return 2;
            }
        }
        return 1;
    }

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        if (super.describe(contents, description) == 0) {
            return 0;
        }
        contents.reset();
        return this.checkCriteria(new InputSource(contents));
    }

    public int describe(Reader contents, IContentDescription description) throws IOException {
        if (super.describe(contents, description) == 0) {
            return 0;
        }
        contents.reset();
        return this.checkCriteria(new InputSource(contents));
    }
}

