/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.springframework.ide.eclipse.beans.core.BeansCoreUtils;
import org.springframework.ide.eclipse.config.ui.wizards.NamespaceConfigWizard;

public class OpenNamespaceConfigWizardCommandHandler
implements IHandler2 {
    private boolean isEnabled;

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            EvaluationContext context = (EvaluationContext)event.getApplicationContext();
            IFile xmlFile = this.getFile(context);
            if (BeansCoreUtils.isBeansConfig((IResource)xmlFile)) {
                EditorPart editor = (EditorPart)context.getParent().getVariable("activePart");
                NamespaceConfigWizard namespaceWizard = new NamespaceConfigWizard(xmlFile, editor);
                WizardDialog wizardDialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)namespaceWizard);
                wizardDialog.setBlockOnOpen(true);
                wizardDialog.create();
                wizardDialog.open();
            } else {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Configure Namespaces", (String)"Namespaces can not be configured for this file.");
            }
        }
        catch (CoreException coreException) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Configure Namespaces", (String)"Namespaces can not be configured for this file.");
        }
        return null;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }

    public void setEnabled(Object evaluationContext) {
        IFile file = this.getFile(evaluationContext);
        this.isEnabled = BeansCoreUtils.isBeansConfig((IResource)file);
    }

    private IFile getFile(Object evaluationContext) {
        EditorPart editor;
        IEditorInput editorInput;
        EvaluationContext context;
        Object activePart;
        if (evaluationContext instanceof EvaluationContext && (activePart = (context = (EvaluationContext)evaluationContext).getParent().getVariable("activePart")) instanceof EditorPart && (editorInput = (editor = (EditorPart)activePart).getEditorInput()) instanceof FileEditorInput) {
            return ((FileEditorInput)editor.getEditorInput()).getFile();
        }
        return null;
    }
}

