/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ui.internal.navigator;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.ui.SpringUIMessages;
import org.springframework.ide.eclipse.ui.SpringUIPlugin;

public class SpringNavigatorDropAdapter
extends CommonDropAdapterAssistant {
    private IProject getProjectFromDropTarget(DropTargetEvent dropTargetEvent) {
        Object object = dropTargetEvent.data;
        if (object instanceof ITreeSelection) {
            object = ((ITreeSelection)object).getFirstElement();
        }
        if (object instanceof IProject) {
            return (IProject)object;
        }
        if (object instanceof IAdaptable) {
            return (IProject)((IAdaptable)object).getAdapter(IProject.class);
        }
        return null;
    }

    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent dropTargetEvent, Object target) {
        IProject project = this.getProjectFromDropTarget(dropTargetEvent);
        if (project == null || SpringCoreUtils.isSpringProject((IResource)project)) {
            return Status.CANCEL_STATUS;
        }
        NullProgressMonitor pm = new NullProgressMonitor();
        try {
            SpringCoreUtils.removeProjectNature((IProject)project, (String)"org.springframework.eclipse.core.springnature", (IProgressMonitor)pm);
            SpringCoreUtils.removeProjectNature((IProject)project, (String)"org.springframework.ide.eclipse.beans.core.beansnature", (IProgressMonitor)pm);
            SpringCoreUtils.addProjectNature((IProject)project, (String)"org.springframework.ide.eclipse.core.springnature", (IProgressMonitor)pm);
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)SpringUIPlugin.getActiveWorkbenchShell(), (String)SpringUIMessages.ProjectNature_errorMessage, (String)NLS.bind((String)SpringUIMessages.ProjectNature_addError, (Object)project.getName(), (Object)e.getLocalizedMessage()));
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        if (operation == 1 && (target instanceof IWorkspaceRoot || target == null)) {
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }
}

