/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ui.internal.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.java.JdtUtils;

public class ResetInternalCacheAction
implements IObjectActionDelegate {
    private List<IProject> selected = new ArrayList<IProject>();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selected.clear();
        if (selection instanceof IStructuredSelection) {
            boolean enabled = true;
            for (Object obj : (IStructuredSelection)selection) {
                if (obj instanceof IJavaProject) {
                    obj = ((IJavaProject)obj).getProject();
                }
                if (obj instanceof IProject) {
                    IProject project = (IProject)obj;
                    if (!project.isOpen()) {
                        enabled = false;
                        break;
                    }
                    this.selected.add(project);
                    continue;
                }
                enabled = false;
                break;
            }
            action.setEnabled(enabled);
        }
    }

    public void run(IAction action) {
        for (IProject project : this.selected) {
            JdtUtils.removeClassLoaderEntryFromCache((IProject)project);
            try {
                project.touch(null);
            }
            catch (CoreException e) {
                SpringCore.log((Throwable)e);
            }
        }
    }
}

