/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ui;

import java.util.LinkedList;
import org.eclipse.jface.viewers.TreePath;

public class TreePathBuilder {
    private final LinkedList<Object> segments = new LinkedList();

    public TreePathBuilder() {
    }

    public TreePathBuilder(Object segment) {
        this.segments.add(segment);
    }

    public TreePathBuilder(TreePathBuilder builder) {
        this.segments.addAll(builder.segments);
    }

    public TreePathBuilder(TreePath path) {
        int i = 0;
        while (i < path.getSegmentCount()) {
            this.segments.addLast(path.getSegment(i));
            ++i;
        }
    }

    public void addParent(Object segment) throws IllegalArgumentException {
        if (this.segments.contains(segment)) {
            throw this.createCyclicPathException(segment);
        }
        this.segments.addFirst(segment);
    }

    public void addChild(Object segment) throws IllegalArgumentException {
        if (this.segments.contains(segment)) {
            throw this.createCyclicPathException(segment);
        }
        this.segments.addLast(segment);
    }

    public TreePath getPath() {
        return new TreePath(this.segments.toArray());
    }

    public TreePath getParentPath() {
        LinkedList<Object> parentSegments = new LinkedList<Object>(this.segments);
        parentSegments.removeLast();
        return new TreePath(parentSegments.toArray());
    }

    public Object getLastSegment() {
        return this.segments.getLast();
    }

    public Object getFirstSegment() {
        return this.segments.getFirst();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (Object e : this.segments) {
            buffer.append(e).append("::");
        }
        return buffer.toString();
    }

    protected IllegalArgumentException createCyclicPathException(Object segment) {
        return new IllegalArgumentException("Cyclic in path '" + this + "' while adding segment '" + segment + "'");
    }
}

