/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.maven.internal.legacyconversion;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.springframework.ide.eclipse.maven.MavenCorePlugin;
import org.springframework.ide.eclipse.maven.internal.legacyconversion.IM2EConstants;
import org.springframework.ide.eclipse.maven.internal.legacyconversion.LegacyProjectsJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyProjectListener
implements IResourceChangeListener,
IM2EConstants {
    public static final LegacyProjectListener LISTENER = new LegacyProjectListener();

    private boolean shouldPerformCheck() {
        return MavenCorePlugin.IS_M2ECLIPSE_PRESENT && !MavenCorePlugin.getDefault().getPreferenceStore().getBoolean("dont.auto.check.for.legacy");
    }

    public void resourceChanged(IResourceChangeEvent event) {
        List<IProject> projects;
        if (event.getType() == 1 && !(projects = this.getProjects(event.getDelta())).isEmpty() && this.shouldPerformCheck()) {
            LegacyProjectsJob job = new LegacyProjectsJob(projects, false, true);
            job.schedule();
        }
    }

    private List<IProject> getProjects(IResourceDelta delta) {
        final ArrayList<IProject> projects = new ArrayList<IProject>();
        try {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IProject project;
                    if (delta.getKind() == 1 && delta.getResource().getType() == 4 && (project = (IProject)delta.getResource()).isAccessible() && project.hasNature("org.maven.ide.eclipse.maven2Nature")) {
                        projects.add(project);
                    }
                    return delta.getResource().getType() == 8;
                }
            });
        }
        catch (CoreException e) {
            MavenCorePlugin.getDefault().getLog().log(e.getStatus());
        }
        return projects;
    }
}

