/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge.editors;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.eclipse.compare.BufferedContent;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;

public class FileNode
extends BufferedContent
implements ITypedElement,
IEditableContent,
IEncodedStreamContentAccessor {
    private File file;
    private String charSet;

    public FileNode(File file) {
        this.file = file;
        Assert.isNotNull((Object)file);
    }

    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        return this.file.getName();
    }

    public String getPrefix() {
        String prefix = null;
        int index = this.getName().indexOf(".");
        prefix = index == -1 ? this.getName() : this.getName().substring(0, index);
        while (prefix.length() < 3) {
            prefix = String.valueOf(prefix) + "_";
        }
        return prefix;
    }

    public String getType() {
        int index = this.getName().indexOf(".");
        if (index != -1 && this.getName().length() > index + 1) {
            return this.getName().substring(index + 1);
        }
        return "txt";
    }

    protected InputStream createStream() throws CoreException {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public void commit(IProgressMonitor pm) throws CoreException {
        byte[] bytes = this.getContent();
        try {
            FileOutputStream os = new FileOutputStream(this.file);
            os.write(bytes);
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isEditable() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public Image getImage() {
        return null;
    }

    public ITypedElement replace(ITypedElement dest, ITypedElement src) {
        return null;
    }

    public String getCharset() throws CoreException {
        return this.charSet;
    }
}

