/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.contentassist.tool;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;
import org.springframework.ide.eclipse.beans.core.namespaces.ToolAnnotationUtils;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.BeanReferenceContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.ClassContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.ClassHierachyContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IAnnotationBasedContentAssistProcessor;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistContext;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistProposalRecorder;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.MethodContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.w3c.dom.Node;

public class ToolAnnotationBasedContentAssistProcessor
implements IAnnotationBasedContentAssistProcessor {
    private static final String REF_ATTRIBUTE = "ref";
    private static final IContentAssistCalculator BEAN_REFERENCE_CALCULATOR = new BeanReferenceContentAssistCalculator(true);

    public void addAttributeValueProposals(IContentAssistContext context, IContentAssistProposalRecorder recorder, Node annotation) {
        if ("annotation".equals(annotation.getLocalName()) && "http://www.springframework.org/schema/tool".equals(annotation.getNamespaceURI())) {
            ToolAnnotationUtils.ToolAnnotationData annotationData = ToolAnnotationUtils.getToolAnnotationData((Node)annotation);
            if (REF_ATTRIBUTE.equals(annotationData.getKind())) {
                BEAN_REFERENCE_CALCULATOR.computeProposals(context, recorder);
            }
            if (Class.class.getName().equals(annotationData.getExpectedType())) {
                if (annotationData.getAssignableTo() == null) {
                    this.getClassContentAssistCalculator(annotationData).computeProposals(context, recorder);
                } else {
                    this.getClassHierachyContentAssistCalculator(annotationData).computeProposals(context, recorder);
                }
            }
            if (annotationData.getExpectedMethodType() != null) {
                String className = this.evaluateXPathExpression(annotationData.getExpectedMethodType(), context.getNode());
                new NonFilteringMethodContentAssistCalculator(className).computeProposals(context, recorder);
            } else if (annotationData.getExpectedMethodRef() != null) {
                String typeName = this.evaluateXPathExpression(annotationData.getExpectedMethodRef(), context.getNode());
                String className = BeansEditorUtils.getClassNameForBean(context.getFile(), context.getDocument(), typeName);
                new NonFilteringMethodContentAssistCalculator(className).computeProposals(context, recorder);
            }
        }
    }

    public void init() {
    }

    protected String evaluateXPathExpression(String xpath, Node node) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath path = factory.newXPath();
        try {
            return path.evaluate(xpath, node);
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    protected IContentAssistCalculator getClassContentAssistCalculator(ToolAnnotationUtils.ToolAnnotationData annotationData) {
        if ("class-only".equals(annotationData.getAssignableToRestriction())) {
            return new ClassContentAssistCalculator(false);
        }
        if ("interface-only".equals(annotationData.getAssignableToRestriction())) {
            return new ClassContentAssistCalculator(true);
        }
        return new ClassContentAssistCalculator();
    }

    protected IContentAssistCalculator getClassHierachyContentAssistCalculator(ToolAnnotationUtils.ToolAnnotationData annotationData) {
        if ("class-only".equals(annotationData.getAssignableToRestriction())) {
            return new ClassHierachyContentAssistCalculator(annotationData.getAssignableTo(), 8);
        }
        if ("interface-only".equals(annotationData.getAssignableToRestriction())) {
            return new ClassHierachyContentAssistCalculator(annotationData.getAssignableTo(), 4);
        }
        return new ClassHierachyContentAssistCalculator(annotationData.getAssignableTo());
    }

    class NonFilteringMethodContentAssistCalculator
    extends MethodContentAssistCalculator {
        private final String className;

        public NonFilteringMethodContentAssistCalculator(String className) {
            super(null);
            this.className = className;
        }

        protected IType calculateType(IContentAssistContext context) {
            IFile file = context.getFile();
            if (file != null && file.exists()) {
                return JdtUtils.getJavaType((IProject)file.getProject(), (String)this.className);
            }
            return null;
        }
    }
}

