/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.contentassist.bean;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.ClassContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistContext;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistProposalRecorder;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.util.StringUtils;

public class PropertyValueContentAssistCalculator
extends ClassContentAssistCalculator
implements IContentAssistCalculator {
    public void computeProposals(IContentAssistContext context, IContentAssistProposalRecorder recorder) {
        String propertyName;
        String matchString = context.getMatchString();
        if (matchString == null || matchString.length() == 0) {
            return;
        }
        if (context.getParentNode() != null && "bean".equals(context.getParentNode().getLocalName()) && StringUtils.hasText((String)(propertyName = BeansEditorUtils.getAttribute(context.getNode(), "name")))) {
            IType type;
            IFile file = context.getFile();
            String className = BeansEditorUtils.getClassNameForBean(file, context.getDocument(), context.getParentNode());
            if (file != null && file.exists() && (type = JdtUtils.getJavaType((IProject)file.getProject(), (String)className)) != null) {
                try {
                    IMethod method = Introspector.getWritableProperty((IType)type, (String)propertyName);
                    if (method != null) {
                        String parameterType = JdtUtils.resolveClassNameBySignature((String)method.getParameterTypes()[0], (IType)type);
                        if (Class.class.getName().equals(parameterType) || String.class.getName().equals(parameterType)) {
                            super.computeProposals(context, recorder);
                        }
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
        }
    }
}

