/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.contentassist.bean;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.AbstractIdContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistContext;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistProposalRecorder;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.JdtUtils;

public class BeanIdContentAssistCalculator
extends AbstractIdContentAssistCalculator {
    public void computeProposals(IContentAssistContext context, IContentAssistProposalRecorder recorder) {
        this.addBeanIdProposal(context, recorder);
    }

    private void addBeanIdProposal(IContentAssistContext context, IContentAssistProposalRecorder recorder) {
        String className = BeansEditorUtils.getClassNameForBean(context.getNode());
        if (className != null) {
            this.createBeanIdProposals(context, recorder, className);
            IFile file = context.getFile();
            if (file != null && file.exists()) {
                IType type = JdtUtils.getJavaType((IProject)file.getProject(), (String)className);
                Set allInterfaces = Introspector.getAllImplementedInterfaces((IType)type);
                for (IType interf : allInterfaces) {
                    this.createBeanIdProposals(context, recorder, interf.getFullyQualifiedName());
                }
            }
        }
    }
}

