/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.contentassist;

import java.util.List;
import org.springframework.ide.eclipse.beans.core.namespaces.ToolAnnotationUtils;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IAnnotationBasedContentAssistProcessor;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistContext;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistProposalRecorder;
import org.springframework.ide.eclipse.beans.ui.editor.namespaces.NamespaceUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ToolAnnotationContentAssistCalulator
implements IContentAssistCalculator {
    public void computeProposals(IContentAssistContext context, IContentAssistProposalRecorder recorder) {
        this.addAnnotationBasedAttributeValueProposals(context, recorder);
    }

    private void addAnnotationBasedAttributeValueProposals(IContentAssistContext context, IContentAssistProposalRecorder recorder) {
        String attributeName = context.getAttributeName();
        List appInfo = ToolAnnotationUtils.getApplicationInformationElements((Node)context.getNode(), (String)attributeName);
        for (Element elem : appInfo) {
            NodeList children = elem.getChildNodes();
            int j = 0;
            while (j < children.getLength()) {
                Node annotationNode = children.item(j);
                if (annotationNode.getNodeType() == 1) {
                    this.invokeAnnotationBasedContentAssistProcessor(context, recorder, annotationNode);
                }
                ++j;
            }
        }
    }

    private void invokeAnnotationBasedContentAssistProcessor(IContentAssistContext context, IContentAssistProposalRecorder recorder, Node annotationNode) {
        IAnnotationBasedContentAssistProcessor[] annotationProcessors;
        IAnnotationBasedContentAssistProcessor[] iAnnotationBasedContentAssistProcessorArray = annotationProcessors = NamespaceUtils.getAnnotationBasedContentAssistProcessor(annotationNode.getNamespaceURI());
        int n = annotationProcessors.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotationBasedContentAssistProcessor annotationProcessor = iAnnotationBasedContentAssistProcessorArray[n2];
            annotationProcessor.addAttributeValueProposals(context, recorder, annotationNode);
            ++n2;
        }
    }
}

