/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.contentassist;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.ui.internal.contentassist.IRelevanceCompletionProposal;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;

public class BeansJavaCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2,
ICompletionProposalExtension4,
ICompletionProposalExtension5,
IRelevanceCompletionProposal {
    private IContextInformation fContextInformation;
    private int fCursorPosition = 0;
    private String fDisplayString;
    private Image fImage;
    private int fOriginalReplacementLength;
    private int fRelevance = 0;
    private int fReplacementLength = 0;
    private int fReplacementOffset = 0;
    private String fReplacementString = null;
    private char[] fTriggers;
    private boolean fUpdateLengthOnValidate;
    private Object proposedObject = null;

    public BeansJavaCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, int relevance, boolean updateReplacementLengthOnValidate, Object proposedObject) {
        this.fReplacementString = "\"" + replacementString;
        this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fCursorPosition = cursorPosition + 1;
        this.fImage = image;
        this.fDisplayString = displayString;
        this.fContextInformation = contextInformation;
        this.fRelevance = relevance;
        this.fUpdateLengthOnValidate = updateReplacementLengthOnValidate;
        this.fOriginalReplacementLength = this.fReplacementLength;
        this.proposedObject = proposedObject;
    }

    public BeansJavaCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, int relevance, Object proposedObject) {
        this(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, relevance, true, proposedObject);
    }

    public void apply(IDocument document) {
        String charBeforeCursor = "";
        try {
            charBeforeCursor = document.get(this.getReplacementOffset() - 1, 1);
        }
        catch (BadLocationException badLocationException) {}
        if ("\"".equals(charBeforeCursor)) {
            CompletionProposal proposal = new CompletionProposal(this.getReplacementString(), this.getReplacementOffset() - 1, this.getReplacementLength(), this.getCursorPosition() + 1, this.getImage(), this.getDisplayString(), this.getContextInformation(), this.getAdditionalProposalInfo());
            proposal.apply(document);
        } else {
            CompletionProposal proposal = new CompletionProposal(String.valueOf(this.getReplacementString()) + "\"", this.getReplacementOffset(), this.getReplacementLength(), this.getCursorPosition() + 1, this.getImage(), this.getDisplayString(), this.getContextInformation(), this.getAdditionalProposalInfo());
            proposal.apply(document);
        }
    }

    public void apply(IDocument document, char trigger, int offset) {
        try {
            document.get(this.getReplacementOffset(), 1);
        }
        catch (BadLocationException badLocationException) {}
        CompletionProposal proposal = new CompletionProposal(String.valueOf(this.getReplacementString()) + "\"", this.getReplacementOffset(), this.getReplacementLength(), this.getCursorPosition() + 1, this.getImage(), this.getDisplayString(), this.getContextInformation(), this.getAdditionalProposalInfo());
        proposal.apply(document);
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument document = viewer.getDocument();
        int caretOffset = viewer.getTextWidget().getCaretOffset();
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            caretOffset = extension.widgetOffset2ModelOffset(caretOffset);
        } else {
            caretOffset = viewer.getTextWidget().getCaretOffset() + viewer.getVisibleRegion().getOffset();
        }
        if (caretOffset == this.getReplacementOffset()) {
            this.apply(document);
        } else {
            try {
                int endOffsetOfChanges = this.getReplacementString().length() + this.getReplacementOffset();
                if (endOffsetOfChanges >= caretOffset) {
                    String charAfterCursor;
                    int postCaretReplacementLength = this.getReplacementOffset() + this.getReplacementLength() - caretOffset;
                    int preCaretReplacementLength = this.getReplacementString().length() - (endOffsetOfChanges - caretOffset);
                    if (postCaretReplacementLength < 0) {
                        postCaretReplacementLength = 0;
                    }
                    if ("\"".equals(charAfterCursor = document.get(caretOffset, 1))) {
                        document.replace(caretOffset, postCaretReplacementLength - 1 < 0 ? postCaretReplacementLength : postCaretReplacementLength - 1, this.getReplacementString().substring(preCaretReplacementLength));
                    } else {
                        document.replace(caretOffset, postCaretReplacementLength, String.valueOf(this.getReplacementString().substring(preCaretReplacementLength)) + "\"");
                    }
                }
                if (caretOffset > this.getReplacementOffset()) {
                    int preCaretTextLength = caretOffset - this.getReplacementOffset();
                    document.replace(this.getReplacementOffset(), preCaretTextLength, this.getReplacementString().substring(0, preCaretTextLength));
                }
            }
            catch (BadLocationException badLocationException) {
                this.apply(document);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                this.apply(document);
            }
        }
    }

    public String getAdditionalProposalInfo() {
        return BeansEditorUtils.createAdditionalProposalInfo(this.getProposedObject(), (IProgressMonitor)new NullProgressMonitor());
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        return BeansEditorUtils.createAdditionalProposalInfo(this.getProposedObject(), monitor);
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public int getContextInformationPosition() {
        return this.getCursorPosition();
    }

    public int getCursorPosition() {
        return this.fCursorPosition;
    }

    public String getDisplayString() {
        return this.fDisplayString;
    }

    public Image getImage() {
        return this.fImage;
    }

    public Object getProposedObject() {
        return this.proposedObject;
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public int getReplacementLength() {
        return this.fReplacementLength;
    }

    public int getReplacementOffset() {
        return this.fReplacementOffset;
    }

    public String getReplacementString() {
        return this.fReplacementString;
    }

    public Point getSelection(IDocument document) {
        CompletionProposal proposal = new CompletionProposal(this.getReplacementString(), this.getReplacementOffset(), this.getReplacementLength(), this.getCursorPosition(), this.getImage(), this.getDisplayString(), this.getContextInformation(), null);
        return proposal.getSelection(document);
    }

    public char[] getTriggerCharacters() {
        return this.fTriggers;
    }

    public boolean isAutoInsertable() {
        return true;
    }

    public boolean isValidFor(IDocument document, int offset) {
        return this.validate(document, offset, null);
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void setContextInformation(IContextInformation contextInfo) {
        this.fContextInformation = contextInfo;
    }

    public void setCursorPosition(int pos) {
        this.fCursorPosition = pos;
    }

    public void setRelevance(int relevance) {
        this.fRelevance = relevance;
    }

    public void setReplacementOffset(int replacementOffset) {
        this.fReplacementOffset = replacementOffset;
    }

    public void setReplacementString(String replacementString) {
        this.fReplacementString = replacementString;
    }

    public void setTriggerCharacters(char[] triggers) {
        this.fTriggers = triggers;
    }

    protected boolean startsWith(IDocument document, int offset, String word) {
        int wordLength;
        int n = wordLength = word == null ? 0 : word.length();
        if (offset > this.fReplacementOffset + wordLength) {
            return false;
        }
        try {
            int length = offset - this.fReplacementOffset;
            String start = document.get(this.fReplacementOffset, length);
            start = start.replaceAll("\"", "");
            String wordTemp = word.replaceAll("\"", "").substring(0, start.length());
            return wordTemp.equalsIgnoreCase(start);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        if (offset < this.fReplacementOffset) {
            return false;
        }
        boolean validated = this.startsWith(document, offset, this.fReplacementString);
        boolean validatedClass = this.startsWith(document, offset, this.fDisplayString);
        if (this.fUpdateLengthOnValidate) {
            int newLength = offset - this.getReplacementOffset();
            int delta = newLength - this.fOriginalReplacementLength;
            this.fReplacementLength = delta + this.fOriginalReplacementLength;
        }
        return validated || validatedClass;
    }
}

