/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.springframework.ide.eclipse.beans.ui.actions.AbstractBeansConfigEditorAction;
import org.springframework.ide.eclipse.beans.ui.search.internal.BeansSearchScope;
import org.springframework.ide.eclipse.beans.ui.search.internal.queries.BeanReferenceQuery;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class SearchBeanReferencesAction
extends AbstractBeansConfigEditorAction {
    public void run(IAction action) {
        ISelection selection;
        String beanId;
        if (this.getTextEditor() != null && (beanId = this.extractBeanId(selection = this.getTextEditor().getSelectionProvider().getSelection())) != null) {
            BeanReferenceQuery query = new BeanReferenceQuery(BeansSearchScope.newSearchScope(), beanId, true, true);
            NewSearchUI.activateSearchResultView();
            NewSearchUI.runQueryInBackground((ISearchQuery)query);
        }
    }

    private String extractBeanId(ISelection selection) {
        Element elem;
        String tagName;
        IStructuredSelection structSelection;
        Object obj;
        String beanId = null;
        if (selection instanceof IStructuredSelection && (obj = (structSelection = (IStructuredSelection)selection).getFirstElement()) instanceof Element && "bean".equals(tagName = (elem = (Element)obj).getTagName())) {
            Attr attribute = elem.getAttributeNode("id");
            if (attribute != null && attribute.getValue() != null) {
                beanId = attribute.getValue();
            }
            if ((attribute = elem.getAttributeNode("name")) != null && attribute.getValue() != null) {
                String[] tokens;
                String[] stringArray = tokens = StringUtils.tokenizeToStringArray((String)attribute.getValue(), (String)",; ");
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    beanId = beanId != null ? String.valueOf(beanId) + "|" + element : element;
                    ++n2;
                }
            }
        }
        return beanId;
    }
}

