/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.type.asm;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.Type;
import org.springframework.ide.eclipse.core.type.AnnotationMetadata;
import org.springframework.ide.eclipse.core.type.asm.ClassMetadataReadingVisitor;
import org.springframework.ide.eclipse.core.type.asm.EmptyAnnotationVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationMetadataReadingVisitor
extends ClassMetadataReadingVisitor
implements AnnotationMetadata {
    private final Map<String, Map<String, Object>> attributesMap = new LinkedHashMap<String, Map<String, Object>>();

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        final String className = Type.getType((String)desc).getClassName();
        final LinkedHashMap attributes = new LinkedHashMap();
        return new EmptyAnnotationVisitor(){

            public void visit(String name, Object value) {
                attributes.put(name, value);
            }

            public void visitEnd() {
                AnnotationMetadataReadingVisitor.this.attributesMap.put(className, attributes);
            }
        };
    }

    @Override
    public Set<String> getAnnotationTypes() {
        return this.attributesMap.keySet();
    }

    @Override
    public boolean hasAnnotation(String annotationType) {
        return this.attributesMap.containsKey(annotationType);
    }

    @Override
    public Map<String, Object> getAnnotationAttributes(String annotationType) {
        return this.attributesMap.get(annotationType);
    }

    @Override
    public String getEnclosingClassName() {
        return null;
    }

    @Override
    public boolean hasEnclosingClass() {
        return false;
    }

    @Override
    public boolean isIndependent() {
        return false;
    }

    @Override
    public boolean isFinal() {
        return false;
    }
}

