/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.model.validation;

import org.eclipse.core.resources.IResource;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.util.ObjectUtils;

public class ValidationProblem {
    private String ruleId;
    private String errorId;
    private int severity;
    private String message;
    private int line;
    private IResource resource;
    private ValidationProblemAttribute[] attributes;

    public ValidationProblem(int severity, String message, IResource resource) {
        this(null, null, severity, message, resource, -1, new ValidationProblemAttribute[0]);
    }

    public ValidationProblem(int severity, String message, IResource resource, int line, ValidationProblemAttribute ... attributes) {
        this(null, null, severity, message, resource, line, attributes);
    }

    public ValidationProblem(String ruleId, String errorId, int severity, String message, IResource resource, int line, ValidationProblemAttribute ... attributes) {
        this.ruleId = ruleId;
        this.severity = severity;
        this.message = message;
        this.line = line;
        this.resource = resource;
        this.attributes = attributes;
        this.errorId = errorId;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public String getErrorId() {
        return this.errorId;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public IResource getResource() {
        return this.resource;
    }

    public int getLine() {
        return this.line;
    }

    public ValidationProblemAttribute[] getAttributes() {
        return this.attributes;
    }

    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode((Object)this.ruleId);
        hashCode = 2 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.errorId);
        hashCode = 3 * hashCode + this.severity;
        hashCode = 4 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.message);
        hashCode = 5 * hashCode + this.line;
        hashCode = 6 * hashCode + ObjectUtils.nullSafeHashCode((Object[])this.attributes);
        hashCode = 7 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.resource);
        return 8 * hashCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ValidationProblem)) {
            return false;
        }
        ValidationProblem that = (ValidationProblem)other;
        if (!ObjectUtils.nullSafeEquals((Object)this.ruleId, (Object)that.ruleId)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.errorId, (Object)that.errorId)) {
            return false;
        }
        if (this.severity != that.severity) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.message, (Object)that.message)) {
            return false;
        }
        if (this.line != that.line) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.attributes, (Object)that.attributes)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.resource, (Object)that.resource)) {
            return false;
        }
        return super.equals(other);
    }
}

